/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pullrequest;

import com.atlassian.stash.internal.notification.pullrequest.PullRequestNotificationAddresser;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.atlassian.stash.notification.Notification;
import com.atlassian.stash.notification.pull.PullRequestNotification;
import com.atlassian.stash.notification.pull.PullRequestReviewerAddedNotification;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.watcher.Watchable;
import com.atlassian.stash.watcher.Watcher;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WatcherPullRequestNotificationAddresser
implements PullRequestNotificationAddresser {
    private static final Logger log = LoggerFactory.getLogger(WatcherPullRequestNotificationAddresser.class);
    private final InternalWatcherService watcherService;
    private final PermissionService permissionService;
    private static final Function<Watcher, StashUser> WATCHER_TO_STASH_USER = new Function<Watcher, StashUser>(){

        public StashUser apply(Watcher watcher) {
            return watcher.getUser();
        }
    };

    @Autowired
    public WatcherPullRequestNotificationAddresser(InternalWatcherService watcherService, PermissionService permissionService) {
        this.watcherService = watcherService;
        this.permissionService = permissionService;
    }

    @Override
    public Iterable<StashUser> getRecipients(Notification notification) {
        if (notification instanceof PullRequestNotification) {
            if (notification instanceof PullRequestReviewerAddedNotification) {
                return ((PullRequestReviewerAddedNotification)notification).getAddedReviewers();
            }
            return this.getWatchers(((PullRequestNotification)notification).getPullRequest());
        }
        return Collections.emptyList();
    }

    private Iterable<StashUser> getWatchers(PullRequest pullRequest) {
        final Repository repository = pullRequest.getToRef().getRepository();
        Predicate<StashUser> permsCheck = new Predicate<StashUser>(){

            public boolean apply(StashUser user) {
                boolean hasEmail = StringUtils.isNotEmpty((String)user.getEmailAddress());
                boolean licensed = WatcherPullRequestNotificationAddresser.this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER);
                boolean hasRead = WatcherPullRequestNotificationAddresser.this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_READ);
                if (!(!log.isDebugEnabled() || hasEmail && licensed && hasRead)) {
                    log.debug("Notification not being sent to {}: hasEmailAddress: {} licensed: {} hasReadOn({}/{}): {}", new Object[]{user.getName(), hasEmail, licensed, repository.getProject().getKey(), repository.getSlug(), hasRead});
                }
                return hasEmail && licensed && hasRead;
            }
        };
        return Chainable.chain((Iterable)this.watcherService.findWatchers((Watchable)pullRequest)).transform(WATCHER_TO_STASH_USER).filter((Predicate)permsCheck);
    }
}

