/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pullrequest;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.pull.PullRequestApprovedEvent;
import com.atlassian.stash.event.pull.PullRequestCommentAddedEvent;
import com.atlassian.stash.event.pull.PullRequestCommentEditedEvent;
import com.atlassian.stash.event.pull.PullRequestCommentRepliedEvent;
import com.atlassian.stash.event.pull.PullRequestDeclinedEvent;
import com.atlassian.stash.event.pull.PullRequestEvent;
import com.atlassian.stash.event.pull.PullRequestMergedEvent;
import com.atlassian.stash.event.pull.PullRequestOpenedEvent;
import com.atlassian.stash.event.pull.PullRequestReopenedEvent;
import com.atlassian.stash.event.pull.PullRequestRescopedEvent;
import com.atlassian.stash.event.pull.PullRequestRolesUpdatedEvent;
import com.atlassian.stash.event.pull.PullRequestUnapprovedEvent;
import com.atlassian.stash.event.pull.PullRequestUpdatedEvent;
import com.atlassian.stash.internal.notification.NotificationManager;
import com.atlassian.stash.notification.Notification;
import com.atlassian.stash.notification.pull.CommentAddedPullRequestNotification;
import com.atlassian.stash.notification.pull.CommentEditedPullRequestNotification;
import com.atlassian.stash.notification.pull.CommentRepliedPullRequestNotification;
import com.atlassian.stash.notification.pull.PullRequestApprovedNotification;
import com.atlassian.stash.notification.pull.PullRequestClosedNotification;
import com.atlassian.stash.notification.pull.PullRequestFromRefRescopedNotification;
import com.atlassian.stash.notification.pull.PullRequestMergedNotification;
import com.atlassian.stash.notification.pull.PullRequestOpenedNotification;
import com.atlassian.stash.notification.pull.PullRequestReopenedNotification;
import com.atlassian.stash.notification.pull.PullRequestReviewerAddedNotification;
import com.atlassian.stash.notification.pull.PullRequestUnapprovedNotification;
import com.atlassian.stash.notification.pull.PullRequestUpdatedNotification;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestParticipant;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullRequestNotificationProducer {
    private static final Function<PullRequestParticipant, StashUser> participantToStashUser = new Function<PullRequestParticipant, StashUser>(){

        public StashUser apply(PullRequestParticipant input) {
            return input.getUser();
        }
    };
    private final NotificationManager notificationManager;

    @Autowired
    public PullRequestNotificationProducer(@Nonnull NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @EventListener
    public void onPullRequestCommentAdded(PullRequestCommentAddedEvent event) {
        CommentAddedPullRequestNotification notification = new CommentAddedPullRequestNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getComment(), event.getAnchor());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestCommentReplied(PullRequestCommentRepliedEvent event) {
        CommentRepliedPullRequestNotification notification = new CommentRepliedPullRequestNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getComment(), event.getParent());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestCommentEdited(PullRequestCommentEditedEvent event) {
        CommentEditedPullRequestNotification notification = new CommentEditedPullRequestNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getComment(), event.getPreviousText());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestUpdatedEvent(PullRequestUpdatedEvent event) {
        this.notificationManager.dispatch((Notification)new PullRequestUpdatedNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getPreviousTitle(), event.getPreviousDescription(), event.getPreviousToBranch()));
    }

    @EventListener
    public void onPullRequestOpened(PullRequestOpenedEvent event) {
        ArrayList reviewers = Lists.newArrayList((Iterable)Collections2.transform((Collection)event.getPullRequest().getReviewers(), participantToStashUser));
        this.dispatchReviewerAddedNotification((PullRequestEvent)event, reviewers);
        this.notificationManager.dispatch((Notification)new PullRequestOpenedNotification(event.getPullRequest(), event.getDate(), event.getUser()));
    }

    @EventListener
    public void onPullRequestRolesUpdated(PullRequestRolesUpdatedEvent event) {
        this.dispatchReviewerAddedNotification((PullRequestEvent)event, Lists.newArrayList((Iterable)event.getAddedReviewers()));
    }

    private void dispatchReviewerAddedNotification(PullRequestEvent event, List<StashUser> reviewers) {
        if (reviewers.size() > 0) {
            PullRequestReviewerAddedNotification notification = new PullRequestReviewerAddedNotification(event.getPullRequest(), event.getDate(), event.getUser(), reviewers);
            this.notificationManager.dispatch((Notification)notification);
        }
    }

    @EventListener
    public void onPullRequestMerged(PullRequestMergedEvent event) {
        PullRequestMergedNotification notification = new PullRequestMergedNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getChangeset());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestClosed(PullRequestDeclinedEvent event) {
        PullRequestClosedNotification notification = new PullRequestClosedNotification(event.getPullRequest(), event.getDate(), event.getUser());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestReopened(PullRequestReopenedEvent event) {
        PullRequestReopenedNotification notification = new PullRequestReopenedNotification(event.getPullRequest(), event.getDate(), event.getUser());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestRescoped(PullRequestRescopedEvent event) {
        PullRequest pullRequest;
        String prevFromHash = event.getPreviousFromHash();
        if (!prevFromHash.equals((pullRequest = event.getPullRequest()).getFromRef().getLatestChangeset())) {
            PullRequestFromRefRescopedNotification notification = new PullRequestFromRefRescopedNotification(pullRequest, event.getDate(), event.getUser(), prevFromHash, event.getPreviousToHash());
            this.notificationManager.dispatch((Notification)notification);
        }
    }

    @EventListener
    public void onPullRequestApproved(PullRequestApprovedEvent event) {
        PullRequestApprovedNotification notification = new PullRequestApprovedNotification(event.getPullRequest(), event.getDate(), event.getUser());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestUnapproved(PullRequestUnapprovedEvent event) {
        PullRequestUnapprovedNotification notification = new PullRequestUnapprovedNotification(event.getPullRequest(), event.getDate(), event.getUser());
        this.notificationManager.dispatch((Notification)notification);
    }
}

