/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.stash.internal.notification.NotificationManager;
import com.atlassian.stash.internal.notification.pullrequest.PullRequestNotificationAddresser;
import com.atlassian.stash.internal.plugin.NotificationHandlerModuleDescriptor;
import com.atlassian.stash.notification.Notification;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultNotificationManager
implements NotificationManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationManager.class);
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final PullRequestNotificationAddresser pullRequestNotificationAddresser;

    @Autowired
    public DefaultNotificationManager(PluginAccessor pluginAccessor, PluginController pluginController, PullRequestNotificationAddresser pullRequestNotificationAddresser) {
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
        this.pullRequestNotificationAddresser = pullRequestNotificationAddresser;
    }

    @Override
    public void dispatch(Notification notification) {
        log.debug("Managing notification: {}", (Object)notification);
        final StashUser initiator = notification.getUser();
        Predicate isNotInitiatorPredicate = initiator != null ? new Predicate<StashUser>(){

            public boolean apply(StashUser user) {
                return !user.equals(initiator);
            }
        } : Predicates.alwaysTrue();
        Iterable recipients = Iterables.filter(this.pullRequestNotificationAddresser.getRecipients(notification), (Predicate)isNotInitiatorPredicate);
        this.dispatch(notification, recipients);
    }

    private void dispatch(Notification notification, Iterable<StashUser> recipients) {
        final Class<?> notificationClass = notification.getClass();
        Predicate<NotificationHandlerModuleDescriptor> forNotificationPredicate = new Predicate<NotificationHandlerModuleDescriptor>(){

            public boolean apply(NotificationHandlerModuleDescriptor descriptor) {
                return descriptor.getNotificationClass().equals(notificationClass.getCanonicalName());
            }
        };
        Collection descriptorsForNotificationType = Collections2.filter((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(NotificationHandlerModuleDescriptor.class), (Predicate)forNotificationPredicate);
        for (NotificationHandlerModuleDescriptor descriptor : descriptorsForNotificationType) {
            try {
                descriptor.getModule().handle(notification, recipients);
            }
            catch (ClassCastException e) {
                String completeModuleKey = descriptor.getCompleteKey();
                log.error("ClassCastException thrown by plugin module {} when handling notification with class {}. Disabling.", (Object)completeModuleKey, notificationClass);
                log.debug("ClassCastException", (Throwable)e);
                this.pluginController.disablePluginModule(completeModuleKey);
            }
        }
    }
}

