/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.restore;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.migration.MigrationState;
import com.atlassian.stash.internal.migration.MigrationException;
import com.atlassian.stash.util.FileUtils;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpackBackupFilesStep
extends AbstractMaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(UnpackBackupFilesStep.class);
    private final I18nService i18nService;
    private volatile int progress;
    private final ApplicationSettings settings;
    private final MigrationState state;

    public UnpackBackupFilesStep(MigrationState state, I18nService i18nService, ApplicationSettings settings) {
        this.i18nService = i18nService;
        this.settings = settings;
        this.state = state;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getText("stash.backup.restore.unpacking.backup", "Unpacking backup files", new Object[0]), this.progress);
    }

    public void run() {
        File backupFile = this.state.getBackupFile();
        Preconditions.checkState((backupFile != null && backupFile.exists() ? 1 : 0) != 0, (Object)"Backup file not found");
        try {
            this.state.setUnzippedBackupDirectory(this.unpackZip(backupFile));
        }
        catch (IOException e) {
            throw new MigrationException(this.i18nService.getKeyedText("stash.backup.restore.unpacking.backup.failed", "Unpacking of backup file {} failed", new Object[]{backupFile.getAbsolutePath()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File unpackZip(File zipFile) throws IOException {
        File directory = FileUtils.createTempDir((String)(zipFile.getName() + "-unpack"), (String)".backup", (File)this.settings.getTempDir());
        log.debug("Unpacking backup files to {}", (Object)directory.getAbsolutePath());
        ZipFile zip = new ZipFile(zipFile);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                if (this.isCanceled()) {
                    log.debug("Canceled while unpacking backup files");
                    File file = directory;
                    return file;
                }
                ZipEntry entry = entries.nextElement();
                File file = new File(directory, entry.getName());
                log.debug("Unpacking {} ({} bytes) to {}", new Object[]{entry.getName(), entry.getSize(), file.getAbsolutePath()});
                long bytes = IOUtils.copyLarge((InputStream)zip.getInputStream(entry), (OutputStream)new FileOutputStream(file));
                if (bytes == entry.getSize()) continue;
                log.warn("{} may not have been completely extracted; unpacked {} bytes where {} were expected", new Object[]{entry.getName(), bytes, entry.getSize()});
            }
            log.debug("All backup files have been unpacked");
        }
        finally {
            this.progress = 100;
            try {
                zip.close();
            }
            catch (IOException e) {
                log.warn("Failed to close backup file " + zipFile.getAbsolutePath(), (Throwable)e);
            }
        }
        return directory;
    }
}

