/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.restore;

import com.atlassian.stash.Product;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.backup.BackupDataSourceSupplier;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseChangeSet;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDataAccessException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseMigrationDao;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseRestoreMonitor;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.restore.RestoreState;
import com.atlassian.stash.util.CancelState;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import com.atlassian.stash.util.SimpleCancelState;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseRestoreStep
implements LiquibaseRestoreMonitor,
MaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(DatabaseRestoreStep.class);
    private final BackupDataSourceSupplier backupDataSourceSupplier;
    private final CancelState cancelState;
    private final I18nService i18nService;
    private final LiquibaseMigrationDao migrationDao;
    private volatile RestoreProgress progress;
    private final ApplicationSettings settings;
    private final RestoreState state;

    public DatabaseRestoreStep(RestoreState state, BackupDataSourceSupplier backupDataSourceSupplier, I18nService i18nService, LiquibaseMigrationDao migrationDao, ApplicationSettings settings) {
        this.backupDataSourceSupplier = backupDataSourceSupplier;
        this.cancelState = new SimpleCancelState();
        this.i18nService = i18nService;
        this.migrationDao = migrationDao;
        this.settings = settings;
        this.state = state;
    }

    public void cancel() {
        this.cancelState.cancel(this.i18nService.getKeyedText("stash.backup.restore.database.canceled", "Restore of {0} data was canceled", new Object[]{Product.NAME}));
    }

    @Nonnull
    public Progress getProgress() {
        RestoreProgress progress = this.progress;
        return progress != null ? progress : new ProgressImpl(this.i18nService.getText("stash.backup.restore.database", "Restoring {0} database", new Object[]{Product.NAME}), 0);
    }

    public void onAppliedChange() {
        RestoreProgress progress = this.progress;
        if (progress == null) {
            throw new IllegalStateException("No current changeset! Must call onBeginChangeset() before calling onAppliedChange().");
        }
        progress.onChange();
    }

    public void onBeginChangeset(LiquibaseChangeSet change, int index, int total) {
        RestoreProgress progress = this.progress;
        this.progress = new RestoreProgress(progress, index, total, change);
    }

    public void onFinishedChangeset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        File backupDir = this.state.getUnzippedBackupDirectory();
        Preconditions.checkState((backupDir != null ? 1 : 0) != 0, (Object)"Unpacked backup not found");
        this.backupDataSourceSupplier.setDataSource(this.state.getTargetDatabase().getDataSource());
        File liquibaseFile = new File(backupDir, "stash-data.xml");
        log.debug("Restoring {} data from {}", (Object)Product.NAME, (Object)liquibaseFile.getAbsolutePath());
        try {
            FileInputStream stream = new FileInputStream(liquibaseFile);
            try {
                try {
                    this.migrationDao.restore((InputStream)stream, this.settings.getTempDir(), (LiquibaseRestoreMonitor)this, this.cancelState);
                }
                catch (LiquibaseDataAccessException e) {
                    throw new BackupException(this.i18nService.getKeyedText("stash.restore.fail", "An error occurred while restoring the database", new Object[0]), (Throwable)e);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        catch (IOException e) {
            throw new BackupException(this.i18nService.getKeyedText("stash.backup.restore.database.failed", "The backup of the database data in {0} could not be restored", new Object[]{liquibaseFile.getAbsolutePath()}), (Throwable)e);
        }
    }

    private class RestoreProgress
    implements Progress {
        private final LiquibaseChangeSet change;
        private final int changesetCount;
        private final int changesetIndex;
        private final int previousWeight;
        private volatile long changesCompleted;

        private RestoreProgress(RestoreProgress previous, int changesetIndex, int changesetCount, LiquibaseChangeSet change) {
            this.change = change;
            this.changesetCount = changesetCount;
            this.changesetIndex = changesetIndex;
            this.previousWeight = previous == null ? 0 : previous.previousWeight + previous.change.getWeight();
        }

        @Nonnull
        public String getMessage() {
            return DatabaseRestoreStep.this.i18nService.getText("stash.restore.changeset.processing", "Executing changeset {0} of {1}, containing {2} changes", new Object[]{this.changesetIndex, this.changesetCount, this.change.getChangeCount()});
        }

        public int getPercentage() {
            return this.previousWeight + (int)(this.changesCompleted * (long)this.change.getWeight() / this.change.getChangeCount());
        }

        public void onChange() {
            ++this.changesCompleted;
        }
    }
}

