/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.stash.Product;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.backup.BackupState;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.LineProcessor;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class ChangelogsBackupStep
extends AbstractMaintenanceTask {
    public static final Pattern PATTERN_INCLUDE = Pattern.compile("\\s+<include file=\"([^\"]+)\"/>$");
    private static final String PATH_LIQUIBASE = "liquibase/";
    private static final String PATH_MASTER = "liquibase/master.xml";
    private static final Logger log = LoggerFactory.getLogger(ChangelogsBackupStep.class);
    private final I18nService i18nService;
    private final BackupState state;
    private volatile int progress;

    public ChangelogsBackupStep(I18nService i18nService, BackupState state) {
        this.i18nService = i18nService;
        this.state = state;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getText("stash.backup.changelog.save", "Backing up database schema definition", new Object[0]), this.progress);
    }

    public void run() {
        ZipOutputStream stream = this.state.getBackupZipStream();
        Preconditions.checkState((stream != null ? 1 : 0) != 0, (Object)"A backup ZipOutputStream is required");
        try {
            ZipEntry entry = new ZipEntry("changelogs.zip");
            stream.putNextEntry(entry);
            log.debug("Backing up database changelogs to {}", (Object)"changelogs.zip");
            ZipOutputStream zip = new ZipOutputStream((OutputStream)new CloseShieldOutputStream((OutputStream)stream));
            try {
                this.writeDatabaseChangelogBackup(zip);
                zip.close();
            }
            catch (IOException e) {
                Closeables.closeQuietly((Closeable)zip);
                throw e;
            }
            stream.closeEntry();
        }
        catch (IOException e) {
            throw new BackupException(this.i18nService.getKeyedText("stash.backup.changelogs.failed", "Backup of {0} changelogs failed.", new Object[]{Product.NAME}), (Throwable)e);
        }
    }

    private void writeDatabaseChangelogBackup(ZipOutputStream stream) throws IOException {
        stream.putNextEntry(new ZipEntry(PATH_LIQUIBASE));
        stream.putNextEntry(new ZipEntry(PATH_MASTER));
        List paths = (List)CharStreams.readLines((InputSupplier)new MasterInputSupplier((OutputStream)stream), (LineProcessor)new PathLineHandler());
        int total = paths.size() + 1;
        for (int i = 1; i < total; ++i) {
            String path = (String)paths.get(i - 1);
            this.progress = 100 * i / total;
            stream.putNextEntry(new ZipEntry(path));
            ByteStreams.copy((InputStream)new ClassPathResource(path).getInputStream(), (OutputStream)stream);
        }
        this.progress = 100;
    }

    private static final class PathLineHandler
    implements LineProcessor<List<String>> {
        private final List<String> paths = Lists.newArrayList();

        private PathLineHandler() {
        }

        public List<String> getResult() {
            return this.paths;
        }

        public boolean processLine(String line) throws IOException {
            Matcher matcher = PATTERN_INCLUDE.matcher(line);
            if (matcher.matches()) {
                this.paths.add(matcher.group(1));
            }
            return true;
        }
    }

    private static final class MasterInputSupplier
    implements InputSupplier<BufferedReader> {
        private final OutputStream outputStream;

        private MasterInputSupplier(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public BufferedReader getInput() throws IOException {
            ClassPathResource master = new ClassPathResource(ChangelogsBackupStep.PATH_MASTER);
            TeeInputStream input = new TeeInputStream(master.getInputStream(), this.outputStream, false);
            InputStreamReader reader = new InputStreamReader((InputStream)input, Charsets.UTF_8);
            return new BufferedReader(reader);
        }
    }
}

