/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.Product;
import com.atlassian.stash.event.backup.BackupCanceledEvent;
import com.atlassian.stash.event.backup.BackupFailedEvent;
import com.atlassian.stash.event.backup.BackupStartedEvent;
import com.atlassian.stash.event.backup.BackupSucceededEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.backup.CanceledBackupException;
import com.atlassian.stash.internal.db.DatabaseLatch;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.maintenance.MaintenanceEvent;
import com.atlassian.stash.internal.maintenance.MaintenanceModePhase;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskFactory;
import com.atlassian.stash.internal.maintenance.MaintenanceType;
import com.atlassian.stash.internal.maintenance.TaskMaintenanceEvent;
import com.atlassian.stash.internal.maintenance.backup.BackupClientPlaceholderStep;
import com.atlassian.stash.internal.maintenance.backup.BackupClientProgressCallback;
import com.atlassian.stash.internal.maintenance.backup.BackupPhase;
import com.atlassian.stash.internal.maintenance.backup.SimpleBackupState;
import com.atlassian.stash.util.Progress;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupTask
implements MaintenanceTask {
    protected static final Logger log = LoggerFactory.getLogger(BackupTask.class);
    private final BackupClientPlaceholderStep backupClientPlaceholderStep;
    private final DatabaseManager databaseManager;
    private final MaintenanceTask delegateTask;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private volatile boolean canceled;

    public BackupTask(DatabaseManager databaseManager, EventPublisher eventPublisher, I18nService i18nService, MaintenanceTaskFactory factory) {
        this.backupClientPlaceholderStep = factory.backupClientBackupStep();
        this.databaseManager = databaseManager;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        SimpleBackupState state = new SimpleBackupState(databaseManager.getHandle());
        TaskMaintenanceEvent event = new TaskMaintenanceEvent(EventType.get((String)"performing-maintenance"), Product.NAME + " is unavailable while it is being backed up", EventLevel.get((String)"maintenance"), MaintenanceType.BACKUP);
        this.delegateTask = ((MaintenanceModePhase.Builder)((MaintenanceModePhase.Builder)((MaintenanceModePhase.Builder)factory.maintenanceModePhaseBuilder().event((MaintenanceEvent)event).add(((BackupPhase.Builder)((BackupPhase.Builder)((BackupPhase.Builder)((BackupPhase.Builder)((BackupPhase.Builder)((BackupPhase.Builder)factory.backupPhaseBuilder(state).add(factory.changelogsBackupStep(state), 2)).add(factory.activeObjectsBackupStep(state), 14)).add(factory.latchAndDrainDatabaseStep(), 3)).add(factory.drainScmStep(), 3)).add(factory.databaseBackupStep(state), 76)).add(factory.configurationBackupStep(state), 2)).build(), 50)).add(this.backupClientPlaceholderStep, 50)).add(factory.unlatchDatabaseStep(null), 0)).build();
    }

    public void cancel() {
        this.canceled = true;
        this.delegateTask.cancel();
    }

    public BackupClientProgressCallback getClientProgressCallback() {
        return this.backupClientPlaceholderStep;
    }

    @Nonnull
    public Progress getProgress() {
        return this.delegateTask.getProgress();
    }

    public void run() {
        try {
            this.eventPublisher.publish((Object)new BackupStartedEvent((Object)this));
            this.delegateTask.run();
            if (this.canceled) {
                throw new CanceledBackupException(this.i18nService.getKeyedText("stash.backup.canceled", "The backup has been canceled.", new Object[0]));
            }
            this.eventPublisher.publish((Object)new BackupSucceededEvent((Object)this));
        }
        catch (Throwable t) {
            this.unlatchDatabase();
            BackupException exception = t instanceof BackupException ? (BackupException)t : new BackupException(this.i18nService.getKeyedText("stash.backup.failed", "{0} could not be backed up.", new Object[]{Product.NAME}), t);
            if (exception instanceof CanceledBackupException) {
                this.eventPublisher.publish((Object)new BackupCanceledEvent((Object)this));
            } else {
                this.eventPublisher.publish((Object)new BackupFailedEvent((Object)this));
            }
            throw exception;
        }
    }

    private void unlatchDatabase() {
        DatabaseLatch latch = this.databaseManager.getCurrentLatch();
        if (latch != null) {
            latch.unlatch();
        }
    }
}

