/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.db.DatabaseHandle;
import com.atlassian.stash.internal.db.DatabaseLatch;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class UnlatchDatabaseStep
extends AbstractMaintenanceTask {
    private final I18nService i18nService;
    private volatile int progress;
    private final DatabaseManager databaseManager;
    private final DatabaseHandle target;

    private UnlatchDatabaseStep(DatabaseHandle targetDatabase, I18nService i18nService, DatabaseManager databaseManager) {
        this.i18nService = i18nService;
        this.databaseManager = databaseManager;
        this.target = targetDatabase;
    }

    @Nonnull
    public Progress getProgress() {
        String message = this.target != null ? this.i18nService.getText("stash.backup.restore.switching.database", "Switching to target database", new Object[0]) : this.i18nService.getText("stash.backup.restore.resuming.database", "Resuming database connection", new Object[0]);
        return new ProgressImpl(message, this.progress);
    }

    public void run() {
        DatabaseLatch latch = this.databaseManager.getCurrentLatch();
        Preconditions.checkState((latch != null ? 1 : 0) != 0, (Object)"The database is not latched");
        if (this.target != null) {
            latch.unlatchTo(this.target);
        } else {
            latch.unlatch();
        }
        this.progress = 100;
    }

    public static class Builder {
        private final I18nService i18nService;
        private final DatabaseManager databaseManager;
        private DatabaseHandle target;

        public Builder(I18nService i18nService, DatabaseManager databaseManager) {
            this.i18nService = i18nService;
            this.databaseManager = databaseManager;
        }

        public Builder target(DatabaseHandle target) {
            this.target = target;
            return this;
        }

        public UnlatchDatabaseStep build() {
            return new UnlatchDatabaseStep(this.target, this.i18nService, this.databaseManager);
        }
    }
}

