/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.db.DatabaseLatch;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.migration.MigrationException;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class LatchAndDrainDatabaseStep
extends AbstractMaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(LatchAndDrainDatabaseStep.class);
    private final I18nService i18nService;
    private final long drainTimeoutSeconds;
    private final DatabaseManager databaseManager;
    private volatile boolean drained;
    private volatile Thread drainingThread;

    public LatchAndDrainDatabaseStep(@Value(value="${backup.drain.database.timeout}") int drainTimeout, I18nService i18nService, DatabaseManager databaseManager) {
        this.drainTimeoutSeconds = drainTimeout;
        this.i18nService = i18nService;
        this.databaseManager = databaseManager;
    }

    @Override
    public void cancel() {
        super.cancel();
        Thread thread = this.drainingThread;
        if (thread != null && !this.drained && thread.getState() == Thread.State.TIMED_WAITING) {
            thread.interrupt();
        }
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getText("stash.migration.closingConnections", "Closing connections to the current database", new Object[0]), this.drained ? 0 : 100);
    }

    public void run() {
        log.debug("Draining the DataSource prior to performing backup for migration");
        DatabaseLatch latch = this.databaseManager.acquireLatch();
        this.drainingThread = Thread.currentThread();
        this.drained = latch.drain(this.drainTimeoutSeconds, TimeUnit.SECONDS);
        this.drainingThread = null;
        if (!this.drained) {
            log.warn("The DataSource could not be drained; some database connections are still open. Aborting migration...");
            if (this.isCanceled()) {
                Thread.interrupted();
            }
            throw new MigrationException(this.i18nService.getKeyedText("stash.migration.drain.failed", "One or more database connections were not closed within the allotted timeout. To prevent corruption due to inconsistent state, the migration has been aborted. Please try your migration again when the system is under less load.", new Object[0]));
        }
        log.debug("The DataSource has been drained");
    }
}

