/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DrainScmStep
extends AbstractMaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(DrainScmStep.class);
    private final I18nService i18nService;
    private final InternalScmService scmService;
    private final long drainTimeoutSeconds;
    private int progress;

    @Autowired
    public DrainScmStep(@Value(value="${backup.drain.scm.timeout}") int drainTimeout, InternalScmService scmService, I18nService i18nService) {
        this.drainTimeoutSeconds = drainTimeout;
        this.i18nService = i18nService;
        this.scmService = scmService;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getText("stash.backup.backup.scm.drain", "Waiting for SCM operations to complete", new Object[0]), this.progress);
    }

    public void run() {
        log.debug("Draining the SCMs prior to performing backup");
        if (!this.scmService.drain(this.drainTimeoutSeconds, TimeUnit.SECONDS)) {
            log.warn("The SCMs could not be drained; some SCM operations are still in progress. Aborting backup...");
            throw new BackupException(this.i18nService.getKeyedText("stash.backup.scm.drain.failed", "Operations from one or more SCMs did not finish within the allotted timeout. To prevent corruption due to inconsistent state, the backup has been aborted. Please try backup up again when the system is under less load.", new Object[0]));
        }
        log.debug("The SCMs have been drained");
        this.progress = 100;
    }
}

