/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.maintenance.IncorrectTokenMaintenanceException;
import com.atlassian.stash.internal.maintenance.MaintenanceCanceled;
import com.atlassian.stash.internal.maintenance.MaintenanceCompletionCallback;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskMonitor;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskState;
import com.atlassian.stash.internal.maintenance.MaintenanceType;
import com.atlassian.stash.request.RequestContext;
import com.atlassian.stash.util.Progress;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMaintenanceTaskMonitor
implements MaintenanceTaskMonitor,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(DefaultMaintenanceTaskMonitor.class);
    private final List<MaintenanceCompletionCallback> callbacks;
    private final String cancelToken;
    private final ListenableFutureTask<Void> future;
    private final I18nService i18nService;
    private final String id;
    private final CountDownLatch latch;
    private final String sessionId;
    private final MaintenanceTask task;
    private final MaintenanceType type;
    private volatile State state;

    public DefaultMaintenanceTaskMonitor(MaintenanceTask task, String id, MaintenanceType type, String sessionId, String cancelToken, I18nService i18nService) {
        this.id = id;
        this.cancelToken = (String)Preconditions.checkNotNull((Object)cancelToken, (Object)"cancelToken");
        this.i18nService = i18nService;
        this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId, (Object)"sessionId");
        this.task = (MaintenanceTask)Preconditions.checkNotNull((Object)task, (Object)"task");
        this.type = type;
        this.callbacks = new CopyOnWriteArrayList<MaintenanceCompletionCallback>();
        this.future = ListenableFutureTask.create((Runnable)this, null);
        this.future.addListener(new Runnable(){

            @Override
            public void run() {
                if (DefaultMaintenanceTaskMonitor.this.future.isCancelled()) {
                    DefaultMaintenanceTaskMonitor.this.task.cancel();
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        this.latch = new CountDownLatch(1);
        this.state = State.CREATED;
    }

    public void registerCallback(MaintenanceCompletionCallback callback) {
        this.callbacks.add(callback);
    }

    public void awaitCompletion() {
        try {
            Uninterruptibles.getUninterruptibly(this.future);
        }
        catch (ExecutionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            Throwables.propagateIfPossible((Throwable)cause);
            throw Throwables.propagate((Throwable)cause);
        }
    }

    public boolean cancel(@Nonnull String token, long timeout, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull((Object)token, (Object)"token");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
        if (this.cancelToken.equals(token)) {
            if (!this.future.isCancelled()) {
                this.future.cancel(true);
            }
            try {
                this.latch.await(timeout, unit);
                return this.state == State.CANCELED;
            }
            catch (InterruptedException e) {
                log.warn("{} maintenance did not cancel within the {} {} timeout", (Object)timeout, (Object)unit);
                return false;
            }
        }
        throw new IncorrectTokenMaintenanceException(this.i18nService.getKeyedText("stash.service.maintenance.task.incorrecttoken", "The provided cancellation token is incorrect.", new Object[0]), token);
    }

    @Nonnull
    public String getCancelToken() {
        return this.cancelToken;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public Progress getProgress() {
        return this.task.getProgress();
    }

    @Nonnull
    public MaintenanceTaskState getState() {
        return this.state.getExternalState();
    }

    @Nonnull
    public MaintenanceType getType() {
        return this.type;
    }

    public boolean isOwner(@Nonnull RequestContext requestContext) {
        Preconditions.checkNotNull((Object)requestContext, (Object)"requestContext");
        return this.sessionId.equals(requestContext.getSessionId());
    }

    @Override
    public void run() {
        this.state = State.RUNNING;
        try {
            this.task.run();
            log.debug("{} maintenance has completed successfully (Canceled: {})", (Object)this.getType(), (Object)this.future.isCancelled());
            this.state = State.SUCCESSFUL;
            for (MaintenanceCompletionCallback callback : this.callbacks) {
                try {
                    callback.onSuccess();
                }
                catch (Exception e) {
                    log.warn("Error while executing a callback on task success", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            String name = t.getClass().getSimpleName();
            if (this.future.isCancelled() && t instanceof MaintenanceCanceled) {
                log.warn("{} maintenance has been canceled (Cause: {}: {})", new Object[]{this.getType(), name, t.getMessage(), t});
                this.state = State.CANCELED;
            } else {
                log.warn("{} maintenance has failed (Cause: {}: {})", new Object[]{this.getType(), name, t.getMessage(), t});
                this.state = State.FAILED;
            }
            for (MaintenanceCompletionCallback callback : this.callbacks) {
                try {
                    if (this.state == State.FAILED) {
                        callback.onFailure(t);
                        continue;
                    }
                    callback.onCancellation();
                }
                catch (Exception e) {
                    log.warn("Error while executing a callback on task failure or cancellation", (Throwable)e);
                }
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw (RuntimeException)t;
        }
        finally {
            this.latch.countDown();
        }
    }

    public ListenableFuture<Void> submitTo(ExecutorService executorService) {
        this.state = State.WAITING;
        executorService.submit((Runnable)this.future);
        return this.future;
    }

    private static enum State {
        CANCELED(MaintenanceTaskState.CANCELED),
        CREATED,
        FAILED(MaintenanceTaskState.FAILED),
        RUNNING,
        SUCCESSFUL(MaintenanceTaskState.SUCCESSFUL),
        WAITING;

        private final MaintenanceTaskState actionState;

        private State() {
            this(MaintenanceTaskState.RUNNING);
        }

        private State(MaintenanceTaskState actionState) {
            this.actionState = actionState;
        }

        public MaintenanceTaskState getExternalState() {
            return this.actionState;
        }
    }
}

