/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.mail.HtmlCssInliner;
import com.atlassian.stash.mail.MailMessage;
import com.atlassian.stash.mail.SoyMailBuilder;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Function;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=SoyMailBuilder.class)
@Component
public class SoyMailBuilderImpl
implements SoyMailBuilder {
    private static final Logger log = LoggerFactory.getLogger(SoyMailBuilderImpl.class);
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final HtmlCssInliner htmlCssInliner;

    @Autowired
    public SoyMailBuilderImpl(SoyTemplateRenderer soyTemplateRenderer, HtmlCssInliner htmlCssInliner) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.htmlCssInliner = htmlCssInliner;
    }

    public Iterable<MailMessage> build(@NotNull Iterable<StashUser> recipients, @NotNull String subject, @NotNull String soyTemplateModuleName, @NotNull String soyTemplateName, @NotNull String cssModuleName, @NotNull Map<String, Object> context, @Nullable Function<MailMessage.Builder, MailMessage.Builder> messageEffector) {
        HashSet<MailMessage> messages = new HashSet<MailMessage>();
        try {
            String text = this.renderText(soyTemplateModuleName, soyTemplateName, cssModuleName, context);
            for (StashUser user : recipients) {
                if (user == null || !StringUtils.isNotBlank((String)user.getEmailAddress())) continue;
                MailMessage.Builder mailMessageBuilder = new MailMessage.Builder().to(new String[]{user.getEmailAddress()}).text(text).subject(subject).header("Content-Type", "text/html; charset=UTF-8");
                if (messageEffector != null) {
                    mailMessageBuilder = (MailMessage.Builder)messageEffector.apply((Object)mailMessageBuilder);
                }
                messages.add(mailMessageBuilder.build());
            }
        }
        catch (SoyException e) {
            log.error("Error rendering email notification (" + soyTemplateModuleName + "/" + soyTemplateName + ")", (Throwable)e);
        }
        return messages;
    }

    private String renderText(String soyTemplateModuleName, String template, String cssModuleName, Map<String, Object> data) throws SoyException {
        return this.htmlCssInliner.inlineCss(this.soyTemplateRenderer.render(soyTemplateModuleName, template, data), cssModuleName);
    }
}

