/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.stash.internal.mail.InsufficientSpaceOnMailQueueException;
import com.atlassian.stash.internal.mail.MailLogger;
import com.atlassian.stash.internal.mail.MailQueueSizeGuard;
import com.atlassian.stash.internal.mail.MailUtils;
import com.atlassian.stash.mail.MailMessage;
import com.atlassian.util.concurrent.atomic.AtomicInteger;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

class DefaultMailQueueSizeGuard
implements MailQueueSizeGuard {
    private final MailLogger mailLogger;
    private final long maxQueueSize;
    private final AtomicInteger queueSize;

    DefaultMailQueueSizeGuard(int maxQueueSize, MailLogger mailLogger) {
        this.mailLogger = mailLogger;
        Preconditions.checkArgument((maxQueueSize > 0 ? 1 : 0) != 0, (Object)"Max queue size can not be negative (mail.max.queue.size)");
        this.queueSize = new AtomicInteger(0);
        this.maxQueueSize = maxQueueSize;
    }

    @Override
    @Nonnull
    public MailQueueSizeGuard.Claim claimSpace(MailMessage mail) {
        final int emailSize = MailUtils.computeSize(mail);
        int newSize = this.queueSize.update((Function)new Function<Integer, Integer>(){

            public Integer apply(Integer currentSize) {
                int requestedSize = currentSize + emailSize;
                if ((long)requestedSize > DefaultMailQueueSizeGuard.this.maxQueueSize) {
                    throw new InsufficientSpaceOnMailQueueException();
                }
                return requestedSize;
            }
        });
        this.mailLogger.logDebugMessage("Queue size is now {}kb", newSize);
        return new MailQueueSizeGuard.Claim(){

            @Override
            public void release() {
                DefaultMailQueueSizeGuard.this.queueSize.update((Function)new Function<Integer, Integer>(){

                    public Integer apply(Integer currentSize) {
                        int desiredSize = currentSize - emailSize;
                        if (desiredSize < 0) {
                            DefaultMailQueueSizeGuard.this.mailLogger.logWarnMessage("The queue size was not properly accounted: its estimated size was {} (now restored to {})", desiredSize, 0);
                            return 0;
                        }
                        return desiredSize;
                    }
                });
            }
        };
    }

    @Override
    public int getReservedSize() {
        return this.queueSize.get();
    }
}

