/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.InternalChangeset;
import com.atlassian.stash.event.RepositoryDeletionRequestedEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.idx.ChangesetAttributeConfiguration;
import com.atlassian.stash.idx.ChangesetIndex;
import com.atlassian.stash.idx.IndexedChangeset;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.content.ChangesetDao;
import com.atlassian.stash.internal.idx.InternalIndexedChangeset;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=ChangesetIndex.class)
@Component(value="changesetIndex")
@Transactional(readOnly=true)
public class DbChangesetIndex
implements ChangesetIndex {
    private static final Logger log = LoggerFactory.getLogger(DbChangesetIndex.class);
    private final ChangesetAttributeConfiguration attributeConfiguration;
    private final Predicate<Repository> canReadRepositoryPredicate;
    private final ChangesetDao changesetDao;
    private final I18nService i18nService;
    @Value(value="${page.max.index.results}")
    private int maxIndexResults;

    @Autowired
    public DbChangesetIndex(ChangesetAttributeConfiguration attributeConfiguration, ChangesetDao changesetDao, I18nService i18nService, PermissionPredicateFactory predicateFactory) {
        this.attributeConfiguration = attributeConfiguration;
        this.canReadRepositoryPredicate = predicateFactory.createRepositoryPermissionPredicate(Permission.REPO_READ);
        this.changesetDao = changesetDao;
        this.i18nService = i18nService;
    }

    @Transactional
    public void addAttribute(@Nonnull String csid, @Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        Preconditions.checkNotNull((Object)name, (Object)"attributeName");
        Preconditions.checkNotNull((Object)value, (Object)"attributeValue");
        this.changesetDao.addAttribute((InternalIndexedChangeset)this.changesetDao.getById((Object)csid), name, value);
    }

    @Transactional
    public void addChangeset(@Nonnull Changeset changeset, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)changeset, (Object)"changeset");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        InternalIndexedChangeset cs = (InternalIndexedChangeset)this.changesetDao.getById((Object)changeset.getId());
        if (cs == null) {
            cs = new InternalIndexedChangeset(changeset.getId(), changeset.getAuthorTimestamp());
            this.changesetDao.create((Object)cs);
        }
        if (!DbChangesetIndex.isPersonalFork(repository)) {
            this.changesetDao.addMembership(cs, InternalConverter.convertToInternalRepository((Repository)repository));
        }
    }

    @Nonnull
    public Changeset enrichChangeset(@Nonnull Changeset changeset, @Nonnull Repository repository, Collection<String> attributeNames) {
        Preconditions.checkNotNull((Object)changeset, (Object)"changeset");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        attributeNames = this.getAttributesToLoad(repository, attributeNames);
        if (attributeNames.isEmpty()) {
            return changeset;
        }
        return this.enrichChangeset(changeset, attributeNames);
    }

    @Nonnull
    public Page<Changeset> enrichChangesets(@Nonnull Page<Changeset> changesets, @Nonnull Repository repository, Collection<String> attributeNames) {
        Preconditions.checkNotNull(changesets, (Object)"changesets");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        attributeNames = this.getAttributesToLoad(repository, attributeNames);
        if (attributeNames.isEmpty()) {
            return changesets;
        }
        return this.enrichChangesets(changesets, attributeNames);
    }

    @Nonnull
    public Page<IndexedChangeset> findChangesetsByAttribute(@Nonnull String attributeName, @Nonnull String attributeValue, boolean caseSensitive, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)attributeName, (Object)"attributeName");
        Preconditions.checkNotNull((Object)attributeValue, (Object)"attributeValue");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxIndexResults);
        List changesets = this.changesetDao.findByAttribute(attributeName, attributeValue, caseSensitive);
        ArrayList<IndexedChangeset> result = new ArrayList<IndexedChangeset>();
        Iterator it = changesets.iterator();
        int pageEndIndex = pageRequest.getStart() + pageRequest.getLimit();
        int index = 0;
        while (index <= pageEndIndex && it.hasNext()) {
            IndexedChangeset changeset = this.transformForPermissions((InternalIndexedChangeset)it.next());
            if (changeset.getRepositories().isEmpty()) continue;
            if (index >= pageRequest.getStart()) {
                result.add(changeset);
            }
            ++index;
        }
        return PageUtils.createPage(result, (PageRequest)pageRequest);
    }

    @Nonnull
    public AttributeMap getAttributeValues(@Nonnull String csid, @Nonnull Collection<String> attributeNames) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        Preconditions.checkNotNull(attributeNames, (Object)"attributeNames");
        return this.changesetDao.getAttributesForChangeset(csid, attributeNames);
    }

    @Nonnull
    public Map<String, AttributeMap> getAttributeValues(@Nonnull Collection<String> csids, @Nonnull Collection<String> attributeNames) {
        Preconditions.checkNotNull(csids, (Object)"changesetIds");
        Preconditions.checkNotNull(attributeNames, (Object)"attributeNames");
        return this.changesetDao.getAttributesForChangesets(csids, attributeNames);
    }

    public IndexedChangeset getChangeset(@Nonnull String csid) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        IndexedChangeset cs = (IndexedChangeset)this.changesetDao.getById((Object)csid);
        if (cs != null && Iterables.any((Iterable)cs.getRepositories(), this.canReadRepositoryPredicate)) {
            return cs;
        }
        return null;
    }

    public boolean isMemberOf(@Nonnull String changesetId, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)changesetId, (Object)"changesetId");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        return this.canReadRepositoryPredicate.apply((Object)repository) && this.changesetDao.isMemberOf(changesetId, InternalConverter.convertToInternalRepository((Repository)repository));
    }

    @EventListener
    public void onRepositoryDeleteRequested(RepositoryDeletionRequestedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Repository repository = event.getRepository();
        try {
            this.changesetDao.deleteAllMemberships(InternalConverter.convertToInternalRepository((Repository)repository));
        }
        catch (RuntimeException e) {
            log.warn("Changeset memberships for " + repository.getProject().getKey() + "/" + repository.getSlug() + " could not be deleted", (Throwable)e);
            event.cancel(this.i18nService.getKeyedText("stash.service.index.cleanupfailed", "Indexing data for {0}/{1} could not be removed. The repository may not be deleted.", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
    }

    @Transactional
    public void removeAttribute(@Nonnull String csid, @Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        Preconditions.checkNotNull((Object)name, (Object)"attributeName");
        Preconditions.checkNotNull((Object)value, (Object)"attributeValue");
        this.changesetDao.removeAttribute(csid, name, value);
    }

    @Transactional
    public void removeChangeset(@Nonnull String csid, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        this.changesetDao.deleteMembership(csid, InternalConverter.convertToInternalRepository((Repository)repository));
    }

    private static boolean isPersonalFork(Repository repository) {
        return repository.isFork() && repository.getProject().getType() == ProjectType.PERSONAL;
    }

    private Changeset enrichChangeset(Changeset changeset, Collection<String> attributeNames) {
        AttributeMap attributeMap = this.getAttributeValues(changeset.getId(), attributeNames);
        return ((InternalChangeset.Builder)new InternalChangeset.Builder(changeset).attributes(attributeMap)).build();
    }

    private Page<Changeset> enrichChangesets(Page<Changeset> changesetPage, Collection<String> attributeNames) {
        HashSet<String> csIds = new HashSet<String>(changesetPage.getSize());
        for (Changeset changeset : changesetPage.getValues()) {
            csIds.add(changeset.getId());
        }
        final Map<String, AttributeMap> csToAttributeMap = this.getAttributeValues(csIds, attributeNames);
        return changesetPage.transform((Function)new Function<Changeset, Changeset>(){

            public Changeset apply(Changeset input) {
                AttributeMap attributeMap = (AttributeMap)csToAttributeMap.get(input.getId());
                if (attributeMap != null && !attributeMap.isEmpty()) {
                    return ((InternalChangeset.Builder)new InternalChangeset.Builder(input).attributes(attributeMap)).build();
                }
                return input;
            }
        });
    }

    private Set<String> getAttributesToLoad(Repository repository, Collection<String> attributesRequested) {
        HashSet attributes = Sets.newHashSet();
        attributes.addAll(this.attributeConfiguration.getAttributesToPreload(repository));
        if (attributesRequested != null) {
            attributes.addAll(attributesRequested);
        }
        return attributes;
    }

    private IndexedChangeset transformForPermissions(final InternalIndexedChangeset changeset) {
        return new IndexedChangeset(){
            private final Set<Repository> visibleRepositories;
            {
                this.visibleRepositories = ImmutableSet.copyOf((Collection)Sets.filter((Set)changeset.getRepositories(), (Predicate)DbChangesetIndex.this.canReadRepositoryPredicate));
            }

            @Nonnull
            public String getId() {
                return changeset.getId();
            }

            @Nonnull
            public Date getAuthorTimestamp() {
                return changeset.getAuthorTimestamp();
            }

            @Nonnull
            public Set<Repository> getRepositories() {
                return this.visibleRepositories;
            }
        };
    }
}

