/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.fugue.Effect;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.exception.ChangesetIndexingException;
import com.atlassian.stash.exception.NoSuchResourceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.idx.ChangesetIndex;
import com.atlassian.stash.idx.ChangesetIndexer;
import com.atlassian.stash.idx.IndexingContext;
import com.atlassian.stash.internal.idx.BlockingChangesetQueueCallback;
import com.atlassian.stash.internal.idx.ChangesetIndexerStateDao;
import com.atlassian.stash.internal.idx.ChangesetIndexingService;
import com.atlassian.stash.internal.idx.DefaultIndexingContext;
import com.atlassian.stash.internal.idx.RepositorySnapshotService;
import com.atlassian.stash.internal.util.TransactionBatcher;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.scm.AsyncCommand;
import com.atlassian.stash.scm.CommitsCommandParameters;
import com.atlassian.stash.scm.ScmCommandFactory;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;

@Service(value="changesetIndexingService")
public class ChangesetIndexingServiceImpl
implements ChangesetIndexingService {
    private static final String MANUALLY_REGISTERED = "manual-indexers";
    private static final Function<ChangesetIndexer, String> TO_ID = new Function<ChangesetIndexer, String>(){

        public String apply(ChangesetIndexer input) {
            return input.getId();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(ChangesetIndexingServiceImpl.class);
    private final ChangesetIndex changesetIndex;
    private final I18nService i18nService;
    private final Multimap<String, ChangesetIndexer> indexers;
    private final ChangesetIndexerStateDao indexerStateDao;
    private final RepositoryService repositoryService;
    private final ScmService scmService;
    private final RepositorySnapshotService snapshotService;
    private final PlatformTransactionManager transactionManager;
    private boolean active;
    @Value(value="${indexing.job.batch.size}")
    private int indexBatchSize;
    @Value(value="${indexing.process.timeout.execution}")
    private long timeoutSeconds;

    @Autowired
    public ChangesetIndexingServiceImpl(ChangesetIndex changesetIndex, I18nService i18nService, ChangesetIndexerStateDao indexerStateDao, RepositoryService repositoryService, ScmService scmService, RepositorySnapshotService snapshotService, PlatformTransactionManager transactionManager) {
        this.changesetIndex = changesetIndex;
        this.i18nService = i18nService;
        this.indexerStateDao = indexerStateDao;
        this.repositoryService = repositoryService;
        this.scmService = scmService;
        this.snapshotService = snapshotService;
        this.transactionManager = transactionManager;
        this.active = true;
        this.indexers = HashMultimap.create((int)2, (int)1);
    }

    @Override
    public void indexRepository(@Nonnull Repository repository) {
        log.debug("[{}] Request for indexing received", (Object)repository);
        if (!this.active) {
            log.info("[{}] Skipping indexing; indexing has been shut down", (Object)repository);
            return;
        }
        List<ChangesetIndexer> enabledIndexers = this.getEnabledIndexers(repository);
        if (enabledIndexers.isEmpty()) {
            log.debug("[{}] Skipping indexing; no enabled indexers found", (Object)repository);
            return;
        }
        new IndexOperation(repository, enabledIndexers).perform();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @PostConstruct
    public void onCreate() {
        this.active = true;
    }

    @PreDestroy
    public void onDestroy() {
        this.active = false;
        log.debug("IndexingService is shutting down. Running indexing jobs will be aborted");
    }

    @PluginEventListener
    public synchronized void onPluginDisabled(PluginDisabledEvent event) {
        this.indexers.removeAll((Object)event.getPlugin().getKey());
    }

    @PluginEventListener
    public synchronized void onPluginEnabled(PluginEnabledEvent event) {
        Plugin plugin = event.getPlugin();
        for (ModuleDescriptor module : plugin.getModuleDescriptorsByModuleClass(ChangesetIndexer.class)) {
            ChangesetIndexer indexer = (ChangesetIndexer)module.getModule();
            if (indexer == null) {
                log.warn("Ignoring module {} from {}; the ChangesetIndexer was null", (Object)module.getKey(), (Object)plugin.getKey());
                continue;
            }
            if (indexer.getId() == null) {
                log.warn("Ignoring module {} from {}; the ChangesetIndexer does not define an ID", (Object)module.getKey(), (Object)plugin.getKey());
                continue;
            }
            log.debug("Registering module {} from {} as a ChangesetIndexer", (Object)module.getKey(), (Object)plugin.getKey());
            this.indexers.put((Object)plugin.getKey(), (Object)indexer);
        }
    }

    @Override
    public void setIndexBatchSize(int indexBatchSize) {
        this.indexBatchSize = indexBatchSize;
    }

    @VisibleForTesting
    synchronized Collection<ChangesetIndexer> getIndexers() {
        return Collections.unmodifiableCollection(this.indexers.values());
    }

    @VisibleForTesting
    synchronized void register(ChangesetIndexer indexer) {
        this.indexers.put((Object)MANUALLY_REGISTERED, (Object)indexer);
    }

    private AsyncCommand<Void> changesetsAdded(Repository repository, Long lastIndexingRun, long thisIndexingRun, ChangesetCallback callback) {
        Iterable<String> currentIndexingHeads = this.snapshotService.create(repository, thisIndexingRun);
        Iterable<String> lastIndexingHeads = this.getIndexedHeadsOrEmpty(repository, lastIndexingRun);
        return this.changesetsBetween(repository, currentIndexingHeads, lastIndexingHeads, callback);
    }

    private AsyncCommand<Void> changesetsBetween(Repository repository, Iterable<String> includedHeads, Iterable<String> excludedHeads, ChangesetCallback callback) {
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory(repository);
        CommitsCommandParameters parameters = new CommitsCommandParameters.Builder().include(includedHeads).exclude(excludedHeads).build();
        return commandFactory.commits(parameters, callback).asynchronous();
    }

    private AsyncCommand<Void> changesetsRemoved(Repository repository, Long lastIndexingRun, long thisIndexingRun, ChangesetCallback callback) {
        Iterable<String> lastIndexingHeads = this.getIndexedHeadsOrEmpty(repository, lastIndexingRun);
        Iterable<String> currentIndexingHeads = this.snapshotService.getByRepository(repository, thisIndexingRun);
        return this.changesetsBetween(repository, lastIndexingHeads, currentIndexingHeads, callback);
    }

    private synchronized List<ChangesetIndexer> getEnabledIndexers(Repository repository) {
        if (this.indexers.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (ChangesetIndexer indexer : this.indexers.values()) {
            if (!indexer.isEnabledForRepository(repository)) continue;
            result.add((Object)indexer);
        }
        return result.build();
    }

    private Iterable<String> getIndexedHeadsOrEmpty(Repository repository, Long timestamp) {
        try {
            return this.snapshotService.getByRepository(repository, timestamp);
        }
        catch (NoSuchResourceException e) {
            log.info("{} The snapshot for the previous indexing run could not be found. Indexing will start from the start of the commit history.", (Object)repository);
            return Collections.emptySet();
        }
    }

    private class IndexOperation
    implements UncheckedOperation<Void> {
        private final List<ChangesetIndexer> enabledIndexers;
        private final int repositoryId;
        private final String identifier;

        private IndexOperation(Repository repository, List<ChangesetIndexer> enabledIndexers) {
            this.enabledIndexers = Lists.newArrayList(enabledIndexers);
            this.identifier = "[" + repository.toString() + "]";
            this.repositoryId = repository.getId();
        }

        public Void perform() {
            this.index();
            return null;
        }

        private long calculateTimeout() {
            return System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(ChangesetIndexingServiceImpl.this.timeoutSeconds);
        }

        private void eachIndexer(Iterable<ChangesetIndexer> indexers, Effect<ChangesetIndexer> effect) {
            Iterator<ChangesetIndexer> it = indexers.iterator();
            while (it.hasNext()) {
                ChangesetIndexer indexer = it.next();
                try {
                    effect.apply((Object)indexer);
                }
                catch (Exception e) {
                    it.remove();
                    log.warn("Changeset indexer {} caused an error '{}' and has been disabled for the remainder of this indexing run. Enable debug logging to see the exception details.", (Object)indexer.getId(), (Object)StringUtils.defaultString((String)e.getMessage()));
                    log.debug("Changeset indexer error:", (Throwable)e);
                }
            }
        }

        private String formatBatchId(int fromBatch) {
            return this.identifier + " indexChangesetBatch(" + fromBatch + ".." + (fromBatch + ChangesetIndexingServiceImpl.this.indexBatchSize) + ")";
        }

        private void handleTimeout(Future<Void> future, long timeoutTimestamp) {
            long now = System.currentTimeMillis();
            if (this.isTimeoutConfigured() && now > timeoutTimestamp) {
                log.info("{} Indexing SCM process has timed out, wrapping up the process", (Object)this.identifier);
                try {
                    future.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    log.debug(this.identifier + " An unexpected exception was thrown while processing an SCM timeout", (Throwable)e);
                }
                catch (TimeoutException e) {
                    KeyedMessage message = ChangesetIndexingServiceImpl.this.i18nService.getKeyedText("stash.service.changesetindexing.timeout", "Indexing has timed out for {0} (Timeout: {1}s)", new Object[]{this.identifier, ChangesetIndexingServiceImpl.this.timeoutSeconds});
                    throw new ChangesetIndexingException(message);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void index() {
            if (log.isDebugEnabled()) {
                log.debug("{} Starting indexing with indexers [{}]", (Object)this.identifier, (Object)StringUtils.join((Collection)Lists.transform(this.enabledIndexers, (Function)TO_ID), (String)", "));
            }
            Timer timer = TimerUtils.start((String)(this.identifier + " index repository"));
            TransactionBatcher batch = new TransactionBatcher(ChangesetIndexingServiceImpl.this.transactionManager, ChangesetIndexingServiceImpl.this.indexBatchSize, this.identifier);
            try {
                batch.start();
                Repository repository = ChangesetIndexingServiceImpl.this.repositoryService.getById(this.repositoryId);
                DefaultIndexingContext ctx = new DefaultIndexingContext(repository);
                ArrayList activeIndexers = Lists.newArrayList(this.enabledIndexers);
                this.notifyOnBefore(activeIndexers, ctx);
                if (activeIndexers.isEmpty()) {
                    log.debug("{} Skipping indexing; all enabled accessors have failed", (Object)this.identifier);
                    return;
                }
                Long lastIndexingRunTimestamp = ChangesetIndexingServiceImpl.this.indexerStateDao.getOldestLastRunTimestamp(repository, (Iterable)activeIndexers);
                if (lastIndexingRunTimestamp == null && ChangesetIndexingServiceImpl.this.scmService.isEmpty(repository)) {
                    log.debug("{} Skipping indexing for empty repository", (Object)this.identifier);
                    batch.commit();
                    return;
                }
                long thisIndexingRunTimestamp = System.currentTimeMillis();
                BlockingChangesetQueueCallback changesetQueue = new BlockingChangesetQueueCallback(1024);
                AsyncCommand command = ChangesetIndexingServiceImpl.this.changesetsAdded(repository, lastIndexingRunTimestamp, thisIndexingRunTimestamp, changesetQueue);
                repository = this.indexChangesets((AsyncCommand<Void>)command, batch, repository, ctx, activeIndexers, changesetQueue, true);
                if (!ChangesetIndexingServiceImpl.this.active) {
                    return;
                }
                log.debug("{} Scanning for deleted changesets...", (Object)this.identifier);
                changesetQueue.clear();
                AsyncCommand delCommand = ChangesetIndexingServiceImpl.this.changesetsRemoved(repository, lastIndexingRunTimestamp, thisIndexingRunTimestamp, changesetQueue);
                repository = this.indexChangesets((AsyncCommand<Void>)delCommand, batch, repository, ctx, activeIndexers, changesetQueue, false);
                if (!ChangesetIndexingServiceImpl.this.active) {
                    return;
                }
                ChangesetIndexingServiceImpl.this.indexerStateDao.setLastRunTimestamp(repository, (Iterable)activeIndexers, thisIndexingRunTimestamp);
                ChangesetIndexingServiceImpl.this.snapshotService.pruneByRepository(repository, ChangesetIndexingServiceImpl.this.indexerStateDao.getReferencedLastRunTimestamps(repository));
                batch.commit();
                this.notifyOnAfter(this.enabledIndexers, ctx);
            }
            finally {
                timer.stop();
                if (batch.rollback()) {
                    log.info("{} Rolled back indexing transaction", (Object)this.identifier);
                }
                log.debug("{} Indexed {} changesets", (Object)this.identifier, (Object)batch.getCount());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Repository indexChangesets(AsyncCommand<Void> command, TransactionBatcher batch, Repository repo, final IndexingContext ctx, List<ChangesetIndexer> activeIndexers, BlockingChangesetQueueCallback changesetQueue, final boolean add) {
            Future result = command.start();
            long timeoutTimestamp = this.calculateTimeout();
            Timer timer = TimerUtils.start((String)this.formatBatchId(batch.getCount()));
            try {
                Changeset changeset;
                while (ChangesetIndexingServiceImpl.this.active && (changeset = changesetQueue.poll(5L, TimeUnit.SECONDS)) != null) {
                    this.handleTimeout(result, timeoutTimestamp);
                    if (add) {
                        ChangesetIndexingServiceImpl.this.changesetIndex.addChangeset(changeset, repo);
                    } else {
                        ChangesetIndexingServiceImpl.this.changesetIndex.removeChangeset(changeset.getId(), repo);
                    }
                    final Changeset cs = changeset;
                    this.eachIndexer(activeIndexers, new Effect<ChangesetIndexer>(){

                        public void apply(ChangesetIndexer indexer) {
                            if (add) {
                                indexer.onChangesetAdded(cs, ctx);
                            } else {
                                indexer.onChangesetRemoved(cs, ctx);
                            }
                        }
                    });
                    if (batch.tick()) {
                        timer.stop();
                        timer = TimerUtils.start((String)this.formatBatchId(batch.getCount()));
                        log.debug("{} Completed batch, Indexed {} so far", (Object)this.identifier, (Object)batch.getCount());
                        repo = ChangesetIndexingServiceImpl.this.repositoryService.getById(repo.getId().intValue());
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace("{} Processed {} - {}", new Object[]{this.identifier, changeset.getId(), batch.getCount()});
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("{} Indexing was interrupted", (Object)this.identifier);
            }
            finally {
                timer.stop();
                this.wrapUpCommand(result);
            }
            return repo;
        }

        private boolean isTimeoutConfigured() {
            return ChangesetIndexingServiceImpl.this.timeoutSeconds > 0L;
        }

        private void notifyOnBefore(List<ChangesetIndexer> indexers, final IndexingContext ctx) {
            Timer timer = TimerUtils.start((String)(this.identifier + " onBeforeIndexing"));
            this.eachIndexer(indexers, new Effect<ChangesetIndexer>(){

                public void apply(ChangesetIndexer indexer) {
                    indexer.onBeforeIndexing(ctx);
                }
            });
            timer.stop();
        }

        private void notifyOnAfter(List<ChangesetIndexer> indexers, final IndexingContext ctx) {
            Timer timer = TimerUtils.start((String)(this.identifier + " onAfterIndexing"));
            this.eachIndexer(indexers, new Effect<ChangesetIndexer>(){

                public void apply(ChangesetIndexer indexer) {
                    indexer.onAfterIndexing(ctx);
                }
            });
            timer.stop();
        }

        private void wrapUpCommand(Future<Void> result) {
            log.trace("{} Waiting for SCM command to wrap up", (Object)this.identifier);
            try {
                result.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                log.debug("{} SCM command did not finish on its own, canceling process", (Object)this.identifier);
                result.cancel(true);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug(this.identifier + " Interrupted while waiting for the process to complete", (Throwable)e);
                result.cancel(true);
            }
            catch (ExecutionException e) {
                log.debug(this.identifier + " Exception happened while waiting for the process to complete", (Throwable)e);
                result.cancel(true);
            }
        }
    }
}

