/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.RepositoryRefsChangedEvent;
import com.atlassian.stash.internal.idx.ChangesetIndexingService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangesetIndexingScheduler {
    public static final int YIELD_THRESHOLD = 3;
    private static final Logger log = LoggerFactory.getLogger(ChangesetIndexingScheduler.class);
    private final ChangesetIndexingService indexingService;
    private final Map<String, PendingRepositories> pending;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final ThreadPoolExecutor threadPool;

    public ChangesetIndexingScheduler(ChangesetIndexingService indexingService, RepositoryService repositoryService, SecurityService securityService, ThreadPoolExecutor threadPool) {
        this.indexingService = indexingService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.threadPool = threadPool;
        this.pending = Maps.newHashMap();
    }

    @EventListener
    public void onRefsChanged(RepositoryRefsChangedEvent event) {
        Repository repository = event.getRepository();
        if (event.getRefChanges().isEmpty()) {
            log.debug("{} Skipping indexing; no refs were changed (Remotely-merged pull request?)", (Object)repository);
        } else {
            this.scheduleIndexing(repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private PendingRepositories getPendingRepositories(String hierarchyId) {
        PendingRepositories repositories = this.pending.get(hierarchyId);
        if (repositories == null) {
            Map<String, PendingRepositories> map = this.pending;
            synchronized (map) {
                repositories = this.pending.get(hierarchyId);
                if (repositories == null) {
                    repositories = new PendingRepositories();
                    this.pending.put(hierarchyId, repositories);
                }
            }
        }
        return repositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleIndexing(Repository repository) {
        PendingRepositories repositories;
        PendingRepositories pendingRepositories = repositories = this.getPendingRepositories(repository.getHierarchyId());
        synchronized (pendingRepositories) {
            repositories.add(repository.getId());
            if (!repositories.isSubmitted()) {
                this.threadPool.submit(new HierarchyIndexer(repositories));
                repositories.setSubmitted(true);
            }
        }
    }

    private static class PendingRepositories
    extends LinkedHashSet<Integer> {
        private boolean submitted;

        private PendingRepositories() {
        }

        private boolean isSubmitted() {
            return this.submitted;
        }

        private void setSubmitted(boolean submitted) {
            this.submitted = submitted;
        }
    }

    private class HierarchyIndexer
    implements Runnable,
    UncheckedOperation<Void> {
        private final PendingRepositories repositories;
        private int processed;

        private HierarchyIndexer(PendingRepositories repositories) {
            this.repositories = repositories;
        }

        public Void perform() {
            Integer repositoryId;
            while ((repositoryId = this.getNextRepository()) != null) {
                Repository repository = ChangesetIndexingScheduler.this.repositoryService.getById(repositoryId.intValue());
                if (repository == null) {
                    log.warn("[{}] Skipping indexing; it appears the repository has been deleted", (Object)repositoryId);
                    continue;
                }
                this.index(repository);
                if (!this.maybeYield()) continue;
                break;
            }
            return null;
        }

        @Override
        public void run() {
            ChangesetIndexingScheduler.this.securityService.doWithPermission("Changeset indexing", Permission.REPO_READ, (Operation)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer getNextRepository() {
            PendingRepositories pendingRepositories = this.repositories;
            synchronized (pendingRepositories) {
                Iterator iterator = this.repositories.iterator();
                if (iterator.hasNext()) {
                    Integer repositoryId = (Integer)iterator.next();
                    iterator.remove();
                    return repositoryId;
                }
                this.repositories.setSubmitted(false);
            }
            return null;
        }

        private void index(Repository repository) {
            try {
                ChangesetIndexingScheduler.this.indexingService.indexRepository(repository);
            }
            catch (Throwable t) {
                if (ChangesetIndexingScheduler.this.indexingService.isActive()) {
                    log.error("[" + repository + "] Indexing failed", t);
                }
                log.info("[{}] Indexing was aborted", (Object)repository);
            }
            ++this.processed;
        }

        private boolean maybeYield() {
            if (this.processed % 3 == 0) {
                try {
                    ChangesetIndexingScheduler.this.threadPool.submit(this);
                    return true;
                }
                catch (RuntimeException e) {
                    log.warn("The indexer could not be rescheduled. It will continue processing", (Throwable)e);
                }
            }
            return false;
        }
    }
}

