/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.content.InternalChangeset;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingChangesetQueueCallback
implements ChangesetCallback {
    private static final Logger log = LoggerFactory.getLogger(BlockingChangesetQueueCallback.class);
    private static final Changeset FINISHED = new InternalChangeset.Builder((Repository)null).id("finished").displayId("finished").build();
    private BlockingQueue<Changeset> queue;
    private boolean finished;

    public BlockingChangesetQueueCallback(int queueSize) {
        Preconditions.checkArgument((queueSize > 0 ? 1 : 0) != 0);
        this.queue = new LinkedBlockingQueue<Changeset>(queueSize);
    }

    public void onStart() {
    }

    public boolean onChangeset(Changeset changeset) {
        if (changeset != null) {
            try {
                this.queue.put(changeset);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug("Process was interrupted while waiting for space on the callback queue to become available", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public Changeset poll(long timeout, TimeUnit unit) throws InterruptedException {
        Changeset result = null;
        if (!this.finished) {
            result = this.queue.poll(timeout, unit);
            this.finished = result == FINISHED;
        }
        return this.finished ? null : result;
    }

    public Changeset poll() throws InterruptedException {
        Changeset result = null;
        if (!this.finished) {
            result = (Changeset)this.queue.poll();
            this.finished = result == FINISHED;
        }
        return this.finished ? null : result;
    }

    public void onEnd() {
        try {
            if (!Thread.currentThread().isInterrupted()) {
                this.queue.put(FINISHED);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Indexing was interrupted", (Throwable)e);
        }
    }

    public void clear() {
        this.queue.clear();
        this.finished = false;
    }
}

