/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.util.concurrent.ConcurrentOperationMap;
import com.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.ObjectUtils;

public class PluginI18nService
implements I18nService {
    private static final Predicate<ResourceDescriptor> I18N_FILTER = new Resources.TypeFilter("i18n");
    private static final Logger log = LoggerFactory.getLogger(PluginI18nService.class);
    private final ConcurrentOperationMap<BundleKey, ResourceBundle> bundleLoader = new ConcurrentOperationMapImpl();
    private final Map<Plugin, Iterable<String>> bundleNamesByPlugin = CopyOnWriteMap.builder().newHashMap();
    private final Map<BundleKey, ResourceBundle> bundles = CopyOnWriteMap.builder().newHashMap();

    public Map<String, String> getAllTranslationsForPrefix(String prefix) {
        return this.getAllTranslationsForPrefix(prefix, LocaleContextHolder.getLocale());
    }

    public Map<String, String> getAllTranslationsForPrefix(String prefix, Locale locale) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
        Preconditions.checkNotNull((Object)locale, (Object)"locale");
        HashMap<String, String> translationsWithPrefix = new HashMap<String, String>();
        for (Map.Entry<Plugin, Iterable<String>> entry : this.bundleNamesByPlugin.entrySet()) {
            this.addMatchingTranslationsToMap(prefix, locale, entry.getKey(), entry.getValue(), translationsWithPrefix);
        }
        return translationsWithPrefix;
    }

    public KeyedMessage getKeyedText(String key, String fallbackMessage, Object ... arguments) {
        return new KeyedMessage(key, this.getText(key, fallbackMessage, arguments), this.getText(Locale.ROOT, key, fallbackMessage, arguments));
    }

    public String getMessagePattern(String key, String fallbackPattern) {
        return this.getMessagePattern(LocaleContextHolder.getLocale(), key, fallbackPattern);
    }

    public String getText(String key, String fallbackMessage, Object ... arguments) {
        return this.getText(LocaleContextHolder.getLocale(), key, fallbackMessage, arguments);
    }

    public String getText(Locale locale, String key, String fallbackMessage, Object ... arguments) {
        String message = null;
        String messagePattern = this.getMessagePattern(locale, key, fallbackMessage);
        if (messagePattern != null) {
            message = MessageFormat.format(messagePattern, arguments);
        }
        if (message == null) {
            return this.formatFallbackMessage(key, fallbackMessage, arguments);
        }
        return message;
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.bundleNamesByPlugin.remove(event.getPlugin());
        this.bundles.clear();
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        Plugin plugin = event.getPlugin();
        Collection i18nDescriptors = Collections2.filter((Collection)plugin.getResourceDescriptors(), I18N_FILTER);
        ArrayList<String> bundleNames = new ArrayList<String>(i18nDescriptors.size());
        for (ResourceDescriptor descriptor : i18nDescriptors) {
            bundleNames.add(descriptor.getLocation());
        }
        this.bundleNamesByPlugin.put(plugin, bundleNames);
    }

    private void addMatchingTranslationsToMap(String prefix, Locale locale, Plugin plugin, Iterable<String> bundleNames, Map<String, String> translationsWithPrefix) {
        for (String bundleName : bundleNames) {
            try {
                ResourceBundle bundle = this.getBundle(bundleName, locale, plugin);
                if (bundle == null) continue;
                this.addMatchingTranslationsToMap(prefix, bundle, translationsWithPrefix);
            }
            catch (MissingResourceException e) {}
        }
    }

    private void addMatchingTranslationsToMap(String prefix, ResourceBundle bundle, Map<String, String> translationsWithPrefix) {
        Enumeration<String> enumeration = bundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            if (!key.startsWith(prefix)) continue;
            translationsWithPrefix.put(key, bundle.getString(key));
        }
    }

    private String formatFallbackMessage(String key, String fallbackMessage, Object[] arguments) {
        String message;
        if (fallbackMessage == null) {
            String string = message = key == null ? "(null)" : key;
            if (arguments != null && arguments.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(message);
                sb.append("[");
                String sep = "";
                for (Object argument : arguments) {
                    sb.append(sep);
                    sb.append(argument == null ? "(null)" : argument.toString());
                    sep = ", ";
                }
                sb.append("]");
                message = sb.toString();
            }
        } else {
            message = MessageFormat.format(fallbackMessage, arguments);
        }
        return message;
    }

    protected ResourceBundle getBundle(String bundleName, Locale locale, Plugin plugin) {
        final BundleKey key = new BundleKey(bundleName, locale, plugin);
        ResourceBundle bundle = this.bundles.get(key);
        if (bundle != null) {
            return bundle;
        }
        try {
            return (ResourceBundle)this.bundleLoader.runOperation((Object)key, (Callable)new Callable<ResourceBundle>(){

                @Override
                public ResourceBundle call() {
                    ResourceBundle bundle = (ResourceBundle)PluginI18nService.this.bundles.get(key);
                    if (bundle == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Cache miss for ResourceBundle {}_{} ({})", new Object[]{key.bundleName, key.locale, key.plugin.getKey()});
                        }
                        bundle = ResourceBundle.getBundle(key.bundleName, key.locale, key.plugin.getClassLoader());
                        PluginI18nService.this.bundles.put(key, bundle);
                    }
                    return bundle;
                }
            });
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private String getMessagePattern(Locale locale, String key, String fallbackPattern) {
        if (key == null) {
            return fallbackPattern;
        }
        for (Map.Entry<Plugin, Iterable<String>> entry : this.bundleNamesByPlugin.entrySet()) {
            for (String bundleName : entry.getValue()) {
                try {
                    ResourceBundle bundle = this.getBundle(bundleName, locale, entry.getKey());
                    if (!bundle.containsKey(key)) continue;
                    return bundle.getString(key);
                }
                catch (MissingResourceException e) {
                }
            }
        }
        return fallbackPattern;
    }

    private static class BundleKey {
        private final String bundleName;
        private final Locale locale;
        private final Plugin plugin;

        private BundleKey(String bundleName, Locale locale, Plugin plugin) {
            this.bundleName = bundleName;
            this.locale = locale;
            this.plugin = plugin;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof BundleKey) {
                BundleKey k = (BundleKey)o;
                return this.bundleName.equals(k.bundleName) && this.locale.equals(k.locale) && this.plugin.equals(k.plugin);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object[])new Object[]{this.bundleName, this.locale, this.plugin});
        }
    }
}

