/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.stash.hook.HookResponse;
import com.atlassian.stash.hook.PreReceiveHook;
import com.atlassian.stash.hook.repository.PreReceiveRepositoryHook;
import com.atlassian.stash.hook.repository.RepositoryHookContext;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.hook.repository.RepositoryHookSettingsCallback;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.setting.Settings;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreReceiveRepositoryHookAdapter
implements PreReceiveHook {
    private static final Logger log = LoggerFactory.getLogger(PreReceiveRepositoryHookAdapter.class);
    private final InternalRepositoryHookService hookService;

    public PreReceiveRepositoryHookAdapter(InternalRepositoryHookService hookService) {
        this.hookService = hookService;
    }

    public boolean onReceive(final @Nonnull Repository repository, final @Nonnull Collection<RefChange> refChanges, final @Nonnull HookResponse hookResponse) {
        return this.hookService.visitEnabledHooks(repository, PreReceiveRepositoryHook.class, (RepositoryHookSettingsCallback)new RepositoryHookSettingsCallback<PreReceiveRepositoryHook>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean visit(String key, PreReceiveRepositoryHook hook, Settings settings) {
                Timer timer = TimerUtils.start((String)(hook.getClass().getName() + "#onReceive"));
                try {
                    if (!hook.onReceive(new RepositoryHookContext(repository, settings), refChanges, hookResponse)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (RuntimeException e) {
                    hookResponse.err().println("Hook " + hook.getClass().getName() + " failed. Error: ");
                    hookResponse.err().println(e.getMessage());
                    log.warn("Receive Hook " + hook.getClass().getName() + " failed.", (Throwable)e);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    timer.stop();
                }
                return true;
            }
        });
    }
}

