/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.avatar.AvatarSupplier;
import com.atlassian.stash.avatar.CacheableAvatarSupplier;
import com.atlassian.stash.avatar.DelegatingCacheableAvatarSupplier;
import com.atlassian.stash.avatar.SimpleAvatarSupplier;
import com.atlassian.stash.event.hook.RepositoryHookDisabledEvent;
import com.atlassian.stash.event.hook.RepositoryHookEnabledEvent;
import com.atlassian.stash.event.hook.RepositoryHookSettingsChangedEvent;
import com.atlassian.stash.exception.FormValidationException;
import com.atlassian.stash.exception.IllegalEntityStateException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.hook.repository.RepositoryHook;
import com.atlassian.stash.hook.repository.RepositoryHookDetails;
import com.atlassian.stash.hook.repository.RepositoryHookImplementor;
import com.atlassian.stash.hook.repository.RepositoryHookService;
import com.atlassian.stash.hook.repository.RepositoryHookType;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.hook.repository.EmptyHookSettings;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHook;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookDetails;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookStatus;
import com.atlassian.stash.internal.hook.repository.RepositoryHookSettingsCallback;
import com.atlassian.stash.internal.hook.repository.RepositoryHookStatusDao;
import com.atlassian.stash.internal.plugin.RepositoryHookModuleDescriptor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositorySettingsService;
import com.atlassian.stash.internal.setting.MapSettingsBuilder;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.setting.Settings;
import com.atlassian.stash.setting.SettingsBuilder;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(value=RepositoryHookService.class)
@Service
public class DefaultRepositoryHookService
extends AbstractService
implements InternalRepositoryHookService {
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositoryHookService.class);
    private static final String HOOK_DEFAULT_ICON = "/hooks/icon-default-hook.png";
    private static final Function<ModuleDescriptor<?>, String> TO_COMPLETE_KEY = new Function<ModuleDescriptor<?>, String>(){

        public String apply(ModuleDescriptor<?> hook) {
            return hook.getCompleteKey();
        }
    };
    private static final Function<RepositoryHookDetails, String> TO_KEY = new Function<RepositoryHookDetails, String>(){

        public String apply(RepositoryHookDetails details) {
            return details.getKey();
        }
    };
    private static final Function<InternalRepositoryHookStatus, String> TO_STATUS_KEY = new Function<InternalRepositoryHookStatus, String>(){

        public String apply(InternalRepositoryHookStatus input) {
            return input.getKey();
        }
    };
    static final int PAGE_SETTINGS_LIMIT = 20;
    private static final Comparator<InternalRepositoryHookDetails> HOOK_NAME_COMPARATOR = new Comparator<InternalRepositoryHookDetails>(){

        @Override
        public int compare(InternalRepositoryHookDetails details1, InternalRepositoryHookDetails details2) {
            return details1.getName().compareTo(details2.getName());
        }
    };
    private final I18nService i18nService;
    private final InternalRepositorySettingsService repositorySettingsService;
    private final PluginAccessor pluginAccessor;
    private final FileNameMap fileNameMap;
    private final RepositoryHookStatusDao hookStatusDao;
    private final TransactionTemplate transactionTemplate;
    private final EventPublisher eventPublisher;

    @Autowired
    public DefaultRepositoryHookService(I18nService i18nService, InternalRepositorySettingsService repositorySettingsService, PluginAccessor pluginAccessor, FileNameMap fileNameMap, RepositoryHookStatusDao hookStatusDao, PlatformTransactionManager platformTransactionManager, EventPublisher eventPublisher) {
        this.i18nService = i18nService;
        this.repositorySettingsService = repositorySettingsService;
        this.pluginAccessor = pluginAccessor;
        this.fileNameMap = fileNameMap;
        this.hookStatusDao = hookStatusDao;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = new TransactionTemplate(platformTransactionManager);
        this.transactionTemplate.setPropagationBehavior(4);
    }

    private Iterable<RepositoryHookModuleDescriptor> getDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(RepositoryHookModuleDescriptor.class);
    }

    private Iterable<InternalRepositoryHookDetails> getByType(RepositoryHookType type) {
        return Chainable.chain(this.getDescriptors()).filter(DefaultRepositoryHookService.isModuleOfType(type)).transform(InternalRepositoryHookDetails.FROM_MODULE_DESCRIPTOR);
    }

    private List<InternalRepositoryHookDetails> getOrdered(Iterable<InternalRepositoryHookDetails> hooks) {
        ArrayList hooksAsList = Lists.newArrayList(hooks);
        Collections.sort(hooksAsList, HOOK_NAME_COMPARATOR);
        return hooksAsList;
    }

    private List<InternalRepositoryHookDetails> getAllOrdered() {
        return this.getOrdered(Iterables.transform(this.getDescriptors(), InternalRepositoryHookDetails.FROM_MODULE_DESCRIPTOR));
    }

    private List<InternalRepositoryHookDetails> getOrderedByType(RepositoryHookType type) {
        return this.getOrdered(this.getByType(type));
    }

    private List<String> getEnabledHookList(Repository repository, Collection<String> moduleKeys) {
        if (moduleKeys.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.transform((List)this.hookStatusDao.findEnabledHooks(InternalConverter.convertToInternalRepository((Repository)repository), moduleKeys), TO_STATUS_KEY);
    }

    private Set<String> getEnabledHooks(Repository repository, Collection<String> moduleKeys) {
        return Sets.newHashSet(this.getEnabledHookList(repository, moduleKeys));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<RepositoryHook> findAll(@Nonnull Repository repository, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        return this.getRepositoryHookPage(repository, pageRequest, this.getAllOrdered());
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<RepositoryHook> findByType(@Nonnull Repository repository, @Nonnull RepositoryHookType type, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)type, (Object)"type");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        List<InternalRepositoryHookDetails> orderedByType = this.getOrderedByType(type);
        return this.getRepositoryHookPage(repository, pageRequest, orderedByType);
    }

    private Page<RepositoryHook> getRepositoryHookPage(Repository repository, PageRequest pageRequest, List<InternalRepositoryHookDetails> orderedByType) {
        if (pageRequest.getStart() > orderedByType.size()) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Page page = PageUtils.createPage(orderedByType.subList(pageRequest.getStart(), orderedByType.size()), (PageRequest)pageRequest);
        ArrayList moduleKeys = Lists.newArrayList((Iterable)Iterables.transform((Iterable)page.getValues(), TO_KEY));
        final Set<String> enabledModules = this.getEnabledHooks(repository, moduleKeys);
        final Collection keysWithSettings = this.repositorySettingsService.findKeysWithSettings(repository, (Collection)moduleKeys);
        return page.transform((Function)new Function<InternalRepositoryHookDetails, RepositoryHook>(){

            public RepositoryHook apply(InternalRepositoryHookDetails details) {
                return new InternalRepositoryHook(details, enabledModules.contains(details.getKey()), keysWithSettings.contains(details.getKey()));
            }
        });
    }

    private boolean hookHasSettingsForRepository(Repository repository, String moduleKeyForHook) {
        return this.repositorySettingsService.findKeysWithSettings(repository, Collections.singleton(moduleKeyForHook)).contains(moduleKeyForHook);
    }

    private RepositoryHookModuleDescriptor getOrThrowModuleDescriptor(String hookKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(hookKey);
        if (!(moduleDescriptor instanceof RepositoryHookModuleDescriptor)) {
            throw new NoSuchEntityException(this.i18nService.getKeyedText("stash.service.repository.hook.nosuchhook", "No such hook exists with key {0}.", new Object[]{hookKey}));
        }
        return (RepositoryHookModuleDescriptor)moduleDescriptor;
    }

    private InternalRepositoryHookDetails getOrThrow(String hookKey) {
        return (InternalRepositoryHookDetails)InternalRepositoryHookDetails.FROM_MODULE_DESCRIPTOR.apply((Object)this.getOrThrowModuleDescriptor(hookKey));
    }

    @Nullable
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public RepositoryHook getByKey(@Nonnull Repository repository, @Nonnull String hookKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(hookKey);
        if (!(moduleDescriptor instanceof RepositoryHookModuleDescriptor)) {
            return null;
        }
        InternalRepositoryHookDetails descriptor = (InternalRepositoryHookDetails)InternalRepositoryHookDetails.FROM_MODULE_DESCRIPTOR.apply((Object)((RepositoryHookModuleDescriptor)moduleDescriptor));
        boolean enabled = this.getEnabledHooks(repository, Collections.singleton(descriptor.getKey())).contains(descriptor.getKey());
        boolean configured = this.hookHasSettingsForRepository(repository, hookKey);
        return new InternalRepositoryHook(descriptor, enabled, configured);
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public RepositoryHook enable(@Nonnull Repository repository, @Nonnull String hookKey) {
        return this.setEnabled(repository, hookKey, true);
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public RepositoryHook enable(@Nonnull Repository repository, @Nonnull String hookKey, @Nonnull Settings settings) throws FormValidationException {
        this.setSettings(repository, hookKey, settings);
        return this.enable(repository, hookKey);
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public RepositoryHook disable(@Nonnull Repository repository, @Nonnull String hookKey) {
        return this.setEnabled(repository, hookKey, false);
    }

    private InternalRepositoryHook setEnabled(Repository repository, String hookKey, boolean enabled) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)hookKey, (Object)"hookKey");
        InternalRepositoryHookDetails details = this.getOrThrow(hookKey);
        InternalRepository internalRepository = InternalConverter.convertToInternalRepository((Repository)repository);
        boolean hasSettings = this.hookHasSettingsForRepository((Repository)internalRepository, hookKey);
        if (enabled && !StringUtils.isEmpty((String)details.getConfigFormKey()) && !hasSettings) {
            throw new IllegalEntityStateException(this.i18nService.getKeyedText("stash.service.hook.notconfigured", "You can not enable a repository hook {0} with no saved configuration", new Object[]{hookKey}));
        }
        InternalRepositoryHookStatus hookStatus = this.hookStatusDao.findHook(internalRepository, hookKey);
        if (hookStatus == null) {
            this.hookStatusDao.create((Object)new InternalRepositoryHookStatus.Builder().key(hookKey).repo(internalRepository).enabled(enabled).build());
        } else {
            this.hookStatusDao.update((Object)new InternalRepositoryHookStatus.Builder(hookStatus).enabled(enabled).build());
        }
        InternalRepositoryHook repositoryHook = new InternalRepositoryHook(details, enabled, hasSettings);
        if (enabled) {
            this.eventPublisher.publish((Object)new RepositoryHookEnabledEvent((Object)this, (Repository)internalRepository, hookKey));
        } else {
            this.eventPublisher.publish((Object)new RepositoryHookDisabledEvent((Object)this, (Repository)internalRepository, hookKey));
        }
        return repositoryHook;
    }

    @Nullable
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Settings getSettings(@Nonnull Repository repository, @Nonnull String hookKey) {
        return this.repositorySettingsService.findByKey(repository, hookKey);
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Settings setSettings(@Nonnull Repository repository, @Nonnull String hookKey, @Nonnull Settings settings) throws FormValidationException {
        Preconditions.checkNotNull((Object)settings, (Object)"settings");
        Settings savedSettings = this.repositorySettingsService.save(repository, hookKey, settings);
        this.eventPublisher.publish((Object)new RepositoryHookSettingsChangedEvent((Object)this, repository, hookKey, savedSettings));
        return savedSettings;
    }

    @Nonnull
    @Unsecured(value="No private data is exposed by this method")
    @Transactional(propagation=Propagation.SUPPORTS)
    public SettingsBuilder createSettingsBuilder() {
        return new MapSettingsBuilder();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public CacheableAvatarSupplier getAvatar(@Nonnull String hookKey) {
        InternalRepositoryHookDetails details = this.getOrThrow(hookKey);
        try {
            URL resource;
            Plugin plugin = this.pluginAccessor.getEnabledPluginModule(hookKey).getPlugin();
            if (details.getIconPath() != null && (resource = plugin.getResource(details.getIconPath())) != null) {
                return this.getCacheableSupplier((Resource)new UrlResource(resource));
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error loading icon for " + hookKey, (Throwable)e);
            }
            log.warn("Error loading icon for {}: {}", (Object)hookKey, (Object)e.getMessage());
        }
        try {
            return this.getCacheableSupplier((Resource)new UrlResource(this.getClass().getResource(HOOK_DEFAULT_ICON)));
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    private CacheableAvatarSupplier getCacheableSupplier(Resource resource) throws IOException {
        return new DelegatingCacheableAvatarSupplier((AvatarSupplier)new SimpleAvatarSupplier(this.fileNameMap.getContentTypeFor(resource.getFilename()), resource.getInputStream()), resource.lastModified());
    }

    private static Predicate<RepositoryHookModuleDescriptor> isModuleOfType(final RepositoryHookType type) {
        return new Predicate<RepositoryHookModuleDescriptor>(){

            public boolean apply(RepositoryHookModuleDescriptor descriptor) {
                return type.equals((Object)descriptor.getType());
            }
        };
    }

    private static <T> Predicate<RepositoryHookModuleDescriptor> isModuleOfType(final Class<T> type) {
        return new Predicate<RepositoryHookModuleDescriptor>(){

            public boolean apply(RepositoryHookModuleDescriptor input) {
                return type.isAssignableFrom(input.getModuleClass());
            }
        };
    }

    @Unsecured(value="This method is internal-only, so it needs no permission checks")
    public <T extends RepositoryHookImplementor> boolean visitEnabledHooks(@Nonnull Repository repository, @Nonnull Class<T> type, @Nonnull RepositoryHookSettingsCallback<T> callback) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(callback, (Object)"callback");
        ImmutableMap matchingModulesMap = Maps.uniqueIndex((Iterable)Chainable.chain(this.getDescriptors()).filter(DefaultRepositoryHookService.isModuleOfType(type)), TO_COMPLETE_KEY);
        List<String> enabledModules = this.getEnabledHookList(repository, matchingModulesMap.keySet());
        if (enabledModules.isEmpty()) {
            return true;
        }
        int batches = (enabledModules.size() + 20 - 1) / 20;
        for (int i = 0; i < batches; ++i) {
            Map settingsMap;
            int offset = i * 20;
            final List<String> pagedEnabledModules = enabledModules.subList(offset, Math.min(enabledModules.size(), offset + 20));
            boolean hooksPassed = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(settingsMap = this.repositorySettingsService.findByRepository(repository, pagedEnabledModules), callback, (Map)matchingModulesMap){
                final /* synthetic */ Map val$settingsMap;
                final /* synthetic */ RepositoryHookSettingsCallback val$callback;
                final /* synthetic */ Map val$matchingModulesMap;
                {
                    this.val$settingsMap = map;
                    this.val$callback = repositoryHookSettingsCallback;
                    this.val$matchingModulesMap = map2;
                }

                public Boolean doInTransaction(TransactionStatus txStatus) {
                    for (String key : pagedEnabledModules) {
                        Settings settings = (Settings)Objects.firstNonNull(this.val$settingsMap.get(key), (Object)EmptyHookSettings.INSTANCE);
                        if (this.val$callback.visit(key, ((RepositoryHookModuleDescriptor)this.val$matchingModulesMap.get(key)).getModule(), settings)) continue;
                        return false;
                    }
                    return true;
                }
            });
            if (hooksPassed) continue;
            return false;
        }
        return true;
    }
}

