/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.stash.hook.BuiltinHookHandlerFactory;
import com.atlassian.stash.hook.HookHandler;
import com.atlassian.stash.hook.HookRequest;
import com.atlassian.stash.hook.HookResponse;
import com.atlassian.stash.hook.PostReceiveHook;
import com.atlassian.stash.hook.PostReceiveHookModuleDescriptor;
import com.atlassian.stash.hook.PreReceiveHook;
import com.atlassian.stash.hook.PreReceiveHookModuleDescriptor;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=BuiltinHookHandlerFactory.class)
@Component(value="builtinHookCallbackFactory")
class DefaultBuiltInHookHandlerFactory
implements BuiltinHookHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultBuiltInHookHandlerFactory.class);
    private final PluginModuleTracker<PreReceiveHook, PreReceiveHookModuleDescriptor> preReceiveHookTracker;
    private final PluginModuleTracker<PostReceiveHook, PostReceiveHookModuleDescriptor> postReceiveHookTracker;

    @Autowired
    public DefaultBuiltInHookHandlerFactory(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.preReceiveHookTracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, PreReceiveHookModuleDescriptor.class);
        this.postReceiveHookTracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, PostReceiveHookModuleDescriptor.class);
    }

    @Nonnull
    public HookHandler preReceive(final @Nonnull Repository repository, final @Nonnull Collection<RefChange> refChanges) {
        return new HookHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean handle(HookRequest request, HookResponse response) {
                Timer loopTimer = TimerUtils.start((String)(this.getClass().getName() + "#preReceive"));
                try {
                    for (PreReceiveHook hook : DefaultBuiltInHookHandlerFactory.this.preReceiveHookTracker.getModules()) {
                        Timer timer = TimerUtils.start((String)(hook.getClass().getName() + "#onReceive"));
                        try {
                            if (hook.onReceive(repository, refChanges, response)) continue;
                            boolean bl = false;
                            return bl;
                        }
                        catch (Exception e) {
                            response.err().println("Hook " + hook.getClass().getName() + " failed. Error: ");
                            response.err().println(e.getMessage());
                            log.warn("PreReceiveHook failed, push will be rejected.", (Throwable)e);
                            boolean bl = false;
                            return bl;
                        }
                        finally {
                            timer.stop();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    loopTimer.stop();
                }
            }
        };
    }

    @Nonnull
    public HookHandler postReceive(final @Nonnull Repository repository, final @Nonnull Collection<RefChange> refChanges) {
        return new HookHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean handle(HookRequest request, HookResponse response) {
                Timer loopTimer = TimerUtils.start((String)(this.getClass().getName() + "#postReceive"));
                try {
                    for (PostReceiveHook hook : DefaultBuiltInHookHandlerFactory.this.postReceiveHookTracker.getModules()) {
                        Timer timer = TimerUtils.start((String)(hook.getClass().getName() + "#onReceive"));
                        try {
                            hook.onReceive(repository, refChanges, response);
                        }
                        catch (Exception e) {
                            log.warn("Hook " + hook.getClass().getName() + " failed.", (Throwable)e);
                        }
                        finally {
                            timer.stop();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    loopTimer.stop();
                }
            }
        };
    }
}

