/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.history;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.content.BatchingChangesetCallback;
import com.atlassian.stash.content.Change;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.content.ChangesetsBetweenRequest;
import com.atlassian.stash.content.DetailedChangeset;
import com.atlassian.stash.content.DetailedChangesetsRequest;
import com.atlassian.stash.history.HistoryService;
import com.atlassian.stash.idx.ChangesetIndex;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ChangesCommandParameters;
import com.atlassian.stash.scm.CommitCommandParameters;
import com.atlassian.stash.scm.CommitsCommandParameters;
import com.atlassian.stash.scm.DetailedCommitsCommandParameters;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=HistoryService.class)
@PreAuthorize(value="isRepositoryAccessible(#repository)")
@Service(value="historyService")
public class HistoryServiceImpl
extends AbstractScmService
implements HistoryService {
    private final ChangesetIndex changesetIndex;
    @Value(value="${page.max.changes}")
    private int maxChanges;
    @Value(value="${page.max.changesets}")
    private int maxChangesets;

    @Autowired
    public HistoryServiceImpl(ScmService scmService, ChangesetIndex changesetIndex) {
        super(scmService);
        this.changesetIndex = changesetIndex;
    }

    @Nonnull
    public Page<Change> getChanges(@Nonnull Repository repository, @Nonnull String changesetId, @Nonnull String parentId, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxChanges);
        ChangesCommandParameters parameters = new ChangesCommandParameters.Builder().sinceId(parentId).untilId(changesetId).build();
        Page page = (Page)this.getCommandFactory(repository).changes(parameters, pageRequest).call();
        if (page == null) {
            page = PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        return page;
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId) {
        return this.getChangeset(repository, changesetId, null, null);
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable String path) {
        return this.getChangeset(repository, changesetId, path, null);
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable Collection<String> attributesToLoad) {
        return this.getChangeset(repository, changesetId, null, attributesToLoad);
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable String path, @Nullable Collection<String> attributesToLoad) {
        Changeset changeset = (Changeset)this.getCommandFactory(repository).commit(((CommitCommandParameters.Builder)((CommitCommandParameters.Builder)new CommitCommandParameters.Builder().changesetId(changesetId)).path(path)).build()).call();
        return this.changesetIndex.enrichChangeset(changeset, repository, attributesToLoad);
    }

    @Nonnull
    public Page<Changeset> getChangesets(@Nonnull Repository repository, @Nullable String changesetId, @Nullable String path, @Nonnull PageRequest pageRequest) {
        return this.getChangesets(repository, changesetId, path, Collections.<String>emptySet(), pageRequest);
    }

    @Nonnull
    public Page<Changeset> getChangesets(@Nonnull Repository repository, @Nullable String changesetId, @Nullable String path, @Nullable Collection<String> attributesToLoad, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxChangesets);
        Page changesets = (Page)this.getCommandFactory(repository).commits(new CommitsCommandParameters.Builder().include(changesetId, new String[0]).path(path).build(), pageRequest).call();
        if (changesets == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.changesetIndex.enrichChangesets(changesets, repository, attributesToLoad);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository) and isRepositoryAccessible(#request.secondaryRepository)")
    public Page<Changeset> getChangesetsBetween(@Nonnull ChangesetsBetweenRequest request, @Nonnull PageRequest pageRequest) {
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxChangesets);
        Page changesets = (Page)this.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).build(), pageRequest).call();
        if (changesets == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.changesetIndex.enrichChangesets(changesets, request.getRepository(), (Collection)request.getLoadAttributes());
    }

    @Nonnull
    public Page<Changeset> getChangesetsBetween(@Nonnull Repository repository, @Nonnull String sinceId, @Nonnull String untilId, @Nonnull PageRequest pageRequest) {
        ChangesetsBetweenRequest request = new ChangesetsBetweenRequest.Builder(repository).exclude(sinceId, new String[0]).include(untilId, new String[0]).build();
        return this.getChangesetsBetween(request, pageRequest);
    }

    @Nonnull
    public Page<Changeset> getChangesetsBetween(@Nonnull Repository repository, @Nonnull String sinceId, @Nonnull String untilId, @Nullable String path, @Nonnull PageRequest pageRequest) {
        ChangesetsBetweenRequest request = new ChangesetsBetweenRequest.Builder(repository).exclude(sinceId, new String[0]).include(untilId, new String[0]).path(path).build();
        return this.getChangesetsBetween(request, pageRequest);
    }

    @Nonnull
    public Page<Changeset> getChangesetsBetween(@Nonnull Repository repository, @Nonnull String sinceId, @Nonnull String untilId, @Nullable Collection<String> attributesToLoad, @Nonnull PageRequest pageRequest) {
        ChangesetsBetweenRequest request = new ChangesetsBetweenRequest.Builder(repository).exclude(sinceId, new String[0]).include(untilId, new String[0]).loadAttributes(attributesToLoad).build();
        return this.getChangesetsBetween(request, pageRequest);
    }

    @Nonnull
    public Page<Changeset> getChangesetsBetween(@Nonnull Repository repository, @Nonnull String sinceId, @Nonnull String untilId, @Nullable String path, @Nullable Collection<String> attributesToLoad, @Nonnull PageRequest pageRequest) {
        ChangesetsBetweenRequest request = new ChangesetsBetweenRequest.Builder(repository).exclude(sinceId, new String[0]).include(untilId, new String[0]).loadAttributes(attributesToLoad).path(path).build();
        return this.getChangesetsBetween(request, pageRequest);
    }

    @Nonnull
    public Page<Changeset> getChangesetsBetween(@Nonnull Repository repository, @Nonnull Collection<String> excludeIds, @Nonnull Collection<String> includeIds, @Nullable Collection<String> paths, @Nullable Collection<String> attributesToLoad, @Nonnull PageRequest pageRequest) {
        ChangesetsBetweenRequest request = new ChangesetsBetweenRequest.Builder(repository).exclude(excludeIds).include(includeIds).loadAttributes(attributesToLoad).paths(paths).build();
        return this.getChangesetsBetween(request, pageRequest);
    }

    @Nonnull
    public Page<DetailedChangeset> getDetailedChangesets(Repository repository, Collection<String> changesetIds, int maxChangesPerChangeset, PageRequest pageRequest) {
        return this.getDetailedChangesets(new DetailedChangesetsRequest.Builder(repository).changesetIds(changesetIds).maxChangesPerCommit(maxChangesPerChangeset).build(), pageRequest);
    }

    @Nonnull
    public Page<DetailedChangeset> getDetailedChangesets(DetailedChangesetsRequest request, PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxChangesets);
        Page page = (Page)this.getCommandFactory(request.getRepository()).detailedCommits(new DetailedCommitsCommandParameters.Builder().changesetIds(request.getChangesetIds()).maxChangesPerCommit(Math.min(request.getMaxChangesPerCommit(), this.maxChanges)).ignoreMissing(request.isIgnoreMissing()).build(), pageRequest).call();
        if (page == null) {
            page = PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        return page;
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository) and isRepositoryAccessible(#request.secondaryRepository)")
    public void streamChangesetsBetween(final @Nonnull ChangesetsBetweenRequest request, @Nonnull ChangesetCallback callback) {
        int batchSize = 25;
        final PageRequest pageRequest = PageUtils.newRequest((int)0, (int)batchSize);
        callback = new BatchingChangesetCallback((ChangesetCallback)callback, batchSize){

            protected boolean onChangesets(Iterable<Changeset> changesets) throws IOException {
                Page page = PageUtils.createPage(changesets, (PageRequest)pageRequest);
                page = HistoryServiceImpl.this.changesetIndex.enrichChangesets(page, request.getRepository(), (Collection)request.getLoadAttributes());
                return super.onChangesets(page.getValues());
            }
        };
        this.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).build(), callback).call();
    }

    public void streamChangesetsBetween(@Nonnull Repository repository, @Nonnull String sinceId, @Nonnull String untilId, @Nullable String path, @Nonnull ChangesetCallback callback) {
        ChangesetsBetweenRequest request = new ChangesetsBetweenRequest.Builder(repository).exclude(sinceId, new String[0]).include(untilId, new String[0]).path(path).build();
        this.streamChangesetsBetween(request, callback);
    }
}

