/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.AccountNotFoundException;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.crowd.exception.runtime.GroupNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.GroupMembershipQuery;
import com.atlassian.crowd.search.query.membership.UserMembersOfGroupQuery;
import com.atlassian.stash.exception.ForbiddenException;
import com.atlassian.stash.exception.IntegrityException;
import com.atlassian.stash.exception.NoSuchGroupException;
import com.atlassian.stash.exception.NoSuchUserException;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.crowd.GroupMatchingFilter;
import com.atlassian.stash.internal.crowd.UserMatchingFilter;
import com.atlassian.stash.user.AuthenticationSystemException;
import com.atlassian.stash.user.ExpiredPasswordAuthenticationException;
import com.atlassian.stash.user.InactiveUserAuthenticationException;
import com.atlassian.stash.user.IncorrectPasswordAuthenticationException;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="crowdControl")
public class RiotPolice
implements CrowdControl {
    private static final Logger log = LoggerFactory.getLogger(RiotPolice.class);
    public static final PropertyRestriction<Boolean> ACTIVE_USERS_ONLY = Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true);
    private final StashAuthenticationContext authenticationContext;
    private final CrowdService crowdService;
    private final DirectoryManager directoryManager;
    private final CrowdDirectoryService directoryService;
    private final I18nService i18nService;

    @Autowired
    public RiotPolice(StashAuthenticationContext authenticationContext, CrowdService crowdService, DirectoryManager directoryManager, CrowdDirectoryService directoryService, I18nService i18nService) {
        this.authenticationContext = authenticationContext;
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
        this.directoryService = directoryService;
        this.i18nService = i18nService;
    }

    public void addGroupMember(final @Nonnull Group group, final @Nonnull User user) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        Preconditions.checkNotNull((Object)user, (Object)"user");
        this.execute(new VoidCrowdCallback(){

            @Override
            protected void internalExecute(CrowdService crowdService) throws CrowdException {
                try {
                    crowdService.addUserToGroup(user, group);
                }
                catch (OperationNotPermittedException e) {
                    log.warn("Could not add " + user.getName() + " to " + group.getName(), (Throwable)e);
                    throw new AuthenticationSystemException(RiotPolice.this.i18nService.getKeyedText("stash.service.addmember.notpermitted", "User {0} could not be added to the {1} group. Verify they are not from a read-only directory or consult the logs for more information on the error.", new Object[]{user.getName(), group.getName()}));
                }
            }
        });
    }

    @Nonnull
    public User authenticate(@Nonnull String username, @Nonnull String password) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        Preconditions.checkNotNull((Object)password, (Object)"password");
        try {
            User user = this.crowdService.authenticate(username, password);
            if (user == null) {
                throw new NoSuchUserException(this.noAccountDetails(username), username);
            }
            return user;
        }
        catch (AccountNotFoundException e) {
            throw this.unknownUser(username);
        }
        catch (ExpiredCredentialException e) {
            throw new ExpiredPasswordAuthenticationException(this.expiredCredentials());
        }
        catch (InactiveAccountException e) {
            throw new InactiveUserAuthenticationException(this.inactiveAccount());
        }
        catch (FailedAuthenticationException e) {
            throw new IncorrectPasswordAuthenticationException(this.authenticationFailed());
        }
        catch (CrowdRuntimeException e) {
            throw new AuthenticationSystemException(this.i18nService.getKeyedText("stash.service.crowd.authenticatefailed", "The remote authentication server is not available. Please try again later.", new Object[0]), (Throwable)e);
        }
    }

    @Nonnull
    public Group createGroup(final @Nonnull Group group) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        return this.execute(new CrowdCallback<Group>(){

            @Override
            public Group execute(CrowdService crowdService) throws CrowdException {
                try {
                    return crowdService.addGroup(group);
                }
                catch (InvalidGroupException e) {
                    throw new IntegrityException(RiotPolice.this.i18nService.getKeyedText("stash.service.group.alreadyexists", "Group {0} already exists.", new Object[]{group.getName()}));
                }
            }
        });
    }

    @Nonnull
    public User createUser(final @Nonnull User user, final @Nonnull String password) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)password, (Object)"password")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        return this.execute(new CrowdCallback<User>(){

            @Override
            public User execute(CrowdService crowdService) throws CrowdException {
                try {
                    return crowdService.addUser(user, password);
                }
                catch (InvalidUserException e) {
                    throw new IntegrityException(RiotPolice.this.i18nService.getKeyedText("stash.service.user.alreadyexists", "User {0} already exists.", new Object[]{user.getName()}));
                }
            }
        });
    }

    public boolean deleteGroup(final @Nonnull Group group) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        return this.execute(new CrowdCallback<Boolean>(){

            @Override
            public Boolean execute(CrowdService crowdService) throws CrowdException {
                try {
                    return crowdService.removeGroup(group);
                }
                catch (OperationNotPermittedException e) {
                    log.warn("Group " + group.getName() + " could not be deleted", (Throwable)e);
                    throw new AuthenticationSystemException(RiotPolice.this.i18nService.getKeyedText("stash.service.group.notdeletable", "Group {0} cannot be deleted; it is either remote or from a read-only directory. Consult the logs for more details.", new Object[]{group.getName()}));
                }
            }
        });
    }

    public boolean deleteUser(final @Nonnull User user) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        return this.execute(new CrowdCallback<Boolean>(){

            @Override
            public Boolean execute(CrowdService crowdService) throws CrowdException {
                try {
                    return crowdService.removeUser(user);
                }
                catch (OperationNotPermittedException e) {
                    log.warn("User " + user.getName() + " could not be deleted", (Throwable)e);
                    throw new AuthenticationSystemException(RiotPolice.this.i18nService.getKeyedText("stash.service.user.notdeletable", "User {0} cannot be deleted; they belong to a read-only directory. Consult the logs for more details.", new Object[]{user.getName()}));
                }
            }
        });
    }

    public Directory findDirectoryFor(@Nonnull User user) {
        return this.directoryService.findDirectoryById(((User)Preconditions.checkNotNull((Object)user, (Object)"user")).getDirectoryId());
    }

    public Group findGroup(@Nonnull String groupName) {
        return this.crowdService.getGroup((String)Preconditions.checkNotNull((Object)groupName, (Object)"groupName"));
    }

    @Nonnull
    public Page<String> findGroups(@Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        GroupQuery query = new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, pageRequest.getStart(), pageRequest.getLimit() + 1);
        return this.getQueryPage((Query)query, pageRequest);
    }

    @Nonnull
    public Page<String> findGroupsByName(String groupName, @Nonnull PageRequest pageRequest) {
        if (StringUtils.isBlank((String)groupName)) {
            return this.findGroups(pageRequest);
        }
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        return new GroupMatchingFilter(this, groupName){

            @Override
            Query<String> getQuery(String filter, int offset, int limit) {
                PropertyRestriction restriction = Restriction.on((Property)GroupTermKeys.NAME).containing((Object)filter);
                return new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)restriction, offset, limit);
            }
        }.scan(pageRequest, groupName);
    }

    @Nonnull
    public Page<String> findGroupsByPrefix(@Nullable String groupPrefix, @Nonnull PageRequest pageRequest) {
        if (StringUtils.isBlank((String)groupPrefix)) {
            return this.findGroups(pageRequest);
        }
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        GroupQuery query = new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)groupPrefix), pageRequest.getStart(), pageRequest.getLimit() + 1);
        return this.getQueryPage((Query)query, pageRequest);
    }

    @Nonnull
    public Page<String> findGroupsByUser(final @Nonnull String username, String groupName, boolean invert, @Nonnull PageRequest pageRequest) {
        GroupMatchingFilter filter;
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        Preconditions.checkNotNull((Object)username, (Object)"username");
        if (invert) {
            final User user = this.findUser(username, true);
            if (user == null) {
                return PageUtils.createEmptyPage((PageRequest)pageRequest);
            }
            final boolean emptyFilter = StringUtils.isBlank((String)groupName);
            filter = new GroupMatchingFilter(this, groupName){

                @Override
                boolean isMatch(String groupName) {
                    return super.isMatch(groupName) && !RiotPolice.this.isGroupMember(groupName, user);
                }

                @Override
                Query<String> getQuery(String groupName, int offset, int limit) {
                    NullRestriction restriction = emptyFilter ? NullRestrictionImpl.INSTANCE : Restriction.on((Property)GroupTermKeys.NAME).containing((Object)groupName);
                    return new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)restriction, offset, limit);
                }
            };
        } else {
            filter = new GroupMatchingFilter(this, groupName){

                @Override
                Query<String> getQuery(String groupName, int offset, int limit) {
                    return new GroupMembershipQuery(String.class, false, EntityDescriptor.user(), username, EntityDescriptor.group(), offset, limit);
                }
            };
        }
        return filter.scan(pageRequest, groupName);
    }

    public User findUser(@Nonnull String username, boolean inactive) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        User user = this.crowdService.getUser(username);
        return user != null && (inactive || user.isActive()) ? user : null;
    }

    @Nullable
    public <T> User findUserByProperty(Property<T> property, T value) {
        return (User)Iterables.getFirst((Iterable)this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{ACTIVE_USERS_ONLY, Restriction.on(property).exactlyMatching(value)})).returningAtMost(1)), null);
    }

    @Nonnull
    public Page<User> findUsers(@Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        UserQuery query = new UserQuery(User.class, ACTIVE_USERS_ONLY, pageRequest.getStart(), pageRequest.getLimit() + 1);
        return this.getQueryPage((Query)query, pageRequest);
    }

    @Nonnull
    public Page<User> findUsersByGroup(final @Nonnull String groupName, String username, boolean invert, @Nonnull PageRequest pageRequest) {
        UserMatchingFilter filter;
        Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        if (invert) {
            final boolean emptyFilter = StringUtils.isBlank((String)username);
            filter = new UserMatchingFilter(this, username){

                @Override
                boolean isMatch(User candidate) {
                    return super.isMatch(candidate) && !RiotPolice.this.isGroupMember(groupName, candidate);
                }

                @Override
                Query<User> getQuery(String username, int offset, int limit) {
                    BooleanRestriction restriction = ACTIVE_USERS_ONLY;
                    if (!emptyFilter) {
                        restriction = Combine.allOf((SearchRestriction[])new SearchRestriction[]{restriction, Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)username), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)username), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)username)})});
                    }
                    return new UserQuery(User.class, restriction, offset, limit);
                }
            };
        } else {
            filter = new UserMatchingFilter(this, username){

                @Override
                boolean isMatch(User user) {
                    return user.isActive() && super.isMatch(user);
                }

                @Override
                Query<User> getQuery(String username, int offset, int limit) {
                    return new UserMembersOfGroupQuery(User.class, true, EntityDescriptor.group(), groupName, EntityDescriptor.user(), offset, limit);
                }
            };
        }
        return filter.scan(pageRequest, username);
    }

    @Nonnull
    public Page<User> findUsersByName(String username, @Nonnull PageRequest pageRequest) {
        if (StringUtils.isBlank((String)username)) {
            return this.findUsers(pageRequest);
        }
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        return new UserMatchingFilter(this, username){

            @Override
            Query<User> getQuery(String filter, int offset, int limit) {
                BooleanRestriction restriction = Combine.allOf((SearchRestriction[])new SearchRestriction[]{ACTIVE_USERS_ONLY, Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)filter), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)filter), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)filter)})});
                return new UserQuery(User.class, (SearchRestriction)restriction, offset, limit);
            }
        }.scan(pageRequest, username);
    }

    public UserWithAttributes findUserWithAttributes(@Nonnull String username) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        UserWithAttributes user = this.crowdService.getUserWithAttributes(username);
        return user != null && user.isActive() ? user : null;
    }

    @Nonnull
    public Group getGroup(@Nonnull String groupName) {
        Group group = this.findGroup(groupName);
        if (group == null) {
            throw new NoSuchGroupException(this.i18nService.getKeyedText("stash.service.groups.noSuchGroup", "No group named ''{0}'' was found", new Object[]{groupName}), groupName);
        }
        return group;
    }

    @Nonnull
    public User getUser(@Nonnull String username) {
        User user = this.findUser(username, false);
        if (user == null) {
            throw new NoSuchUserException(this.i18nService.getKeyedText("stash.service.users.noSuchUser", "No user named ''{0}'' was found", new Object[]{username}), username);
        }
        return user;
    }

    public boolean isGroupMember(@Nonnull String groupName, @Nonnull User user) {
        Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
        Preconditions.checkNotNull((Object)user, (Object)"user");
        long directoryId = user.getDirectoryId();
        try {
            return this.directoryManager.isUserNestedGroupMember(directoryId, user.getName(), groupName);
        }
        catch (DirectoryNotFoundException e) {
            log.error(String.format("No directory exists with ID %1$d", directoryId), (Throwable)e);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            log.error(String.format("Could not determine group membership in %1$s for %2$s", groupName, user.getName()), (Throwable)e);
        }
        return false;
    }

    public boolean isGroupMemberOfGroup(@Nonnull String childGroupName, @Nonnull String parentGroupName) {
        Preconditions.checkNotNull((Object)childGroupName, (Object)"childGroupName");
        Preconditions.checkNotNull((Object)parentGroupName, (Object)"parentGroupName");
        return this.crowdService.isGroupMemberOfGroup(childGroupName, parentGroupName);
    }

    @Nonnull
    public List<Directory> listDirectories() {
        return this.directoryService.findAllDirectories();
    }

    public boolean removeGroupMember(final @Nonnull Group group, final @Nonnull User user) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        Preconditions.checkNotNull((Object)user, (Object)"user");
        return this.execute(new CrowdCallback<Boolean>(){

            @Override
            public Boolean execute(CrowdService crowdService) throws CrowdException {
                try {
                    return crowdService.removeUserFromGroup(user, group);
                }
                catch (GroupNotFoundException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Failed to remove " + user.getName() + " from " + group.getName() + " because the group was not found", (Throwable)e);
                    }
                    return false;
                }
                catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Failed to remove " + user.getName() + " from " + group.getName() + " because the user was not found", (Throwable)e);
                    }
                    return false;
                }
                catch (OperationNotPermittedException e) {
                    log.warn("Could not remove " + user.getName() + " from " + group.getName(), (Throwable)e);
                    throw new AuthenticationSystemException(RiotPolice.this.i18nService.getKeyedText("stash.service.removemember.notpermitted", "User {0} could not be removed from the {1} group. Verify they are not from a read-only directory or consult the logs for more information on the error.", new Object[]{user.getName(), group.getName()}));
                }
            }
        });
    }

    public void removeUserAttribute(final @Nonnull User user, final @Nonnull String attributeName) {
        Preconditions.checkNotNull((Object)attributeName, (Object)"attributeName");
        Preconditions.checkNotNull((Object)user, (Object)"user");
        this.execute(new VoidCrowdCallback(){

            @Override
            protected void internalExecute(CrowdService crowdService) throws CrowdException {
                crowdService.removeUserAttribute(user, attributeName);
            }
        });
    }

    public User renameUser(final @Nonnull User user, final @Nonnull String newUsername) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        Preconditions.checkNotNull((Object)newUsername, (Object)"newUserName");
        return this.execute(new CrowdCallback<User>(){

            @Override
            public User execute(CrowdService crowdService) throws CrowdException {
                try {
                    return crowdService.renameUser(user, newUsername);
                }
                catch (OperationFailedException e) {
                    throw new IntegrityException(RiotPolice.this.i18nService.getKeyedText("stash.service.user.alreadyexists", "User {0} already exists.", new Object[]{newUsername}));
                }
                catch (UnsupportedOperationException e) {
                    Directory directory = RiotPolice.this.directoryManager.findDirectoryById(user.getDirectoryId());
                    throw new ForbiddenException(RiotPolice.this.i18nService.getKeyedText("stash.service.user.rename.not.allowed", "Renaming users is not supported for directory ''{0}''", new Object[]{directory.getName()}));
                }
            }
        });
    }

    @Nonnull
    <T> Iterable<T> search(@Nonnull Query<T> query) {
        return this.crowdService.search((Query)Preconditions.checkNotNull(query, (Object)"query"));
    }

    public void setPassword(@Nonnull User user, @Nonnull String password) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)password, (Object)"password")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        try {
            this.crowdService.updateUserCredential(user, password);
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            throw this.unknownUser(user.getName());
        }
        catch (CrowdRuntimeException e) {
            throw this.cannotUpdatePassword(user.getName(), (Exception)((Object)e));
        }
        catch (CrowdException e) {
            throw this.cannotUpdatePassword(user.getName(), (Exception)((Object)e));
        }
    }

    public void setUserAttribute(final @Nonnull User user, final @Nonnull String attributeName, final @Nonnull Object attributeValue) {
        Preconditions.checkNotNull((Object)attributeName, (Object)"attributeName");
        Preconditions.checkNotNull((Object)attributeValue, (Object)"attributeValue");
        Preconditions.checkNotNull((Object)user, (Object)"user");
        this.execute(new VoidCrowdCallback(){

            @Override
            protected void internalExecute(CrowdService crowdService) throws CrowdException {
                try {
                    crowdService.setUserAttribute(user, attributeName, String.valueOf(attributeValue));
                }
                catch (OperationNotPermittedException e) {
                    String message = String.format("Couldn't update the %1$s attribute for %2$s", attributeName, user.getName());
                    if (log.isDebugEnabled()) {
                        log.debug(message, (Throwable)e);
                    }
                    log.error(message);
                }
            }
        });
    }

    @Nonnull
    public User updateUser(@Nonnull User user) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        try {
            return this.crowdService.updateUser(user);
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            throw this.unknownUser(user.getName());
        }
        catch (CrowdRuntimeException e) {
            throw this.cannotUpdateProfile(user, (Exception)((Object)e));
        }
        catch (CrowdException e) {
            throw this.cannotUpdateProfile(user, (Exception)((Object)e));
        }
    }

    private KeyedMessage authenticationFailed() {
        return this.i18nService.getKeyedText("stash.service.user.authenticationfailed", "Authentication failed because the user does not exist, the account is inactive, or the provided credentials are incorrect", new Object[0]);
    }

    private ServerException cannotUpdateOtherProfile(String username, Exception e) {
        KeyedMessage keyedText = this.i18nService.getKeyedText("stash.service.users.canNotUpdate", "Could not update user profile for {0}", new Object[]{username});
        if (log.isDebugEnabled()) {
            log.debug("The user profile for " + username + " could not be updated", (Throwable)e);
        }
        throw new ServerException(keyedText, (Throwable)e);
    }

    private ServerException cannotUpdateOwnProfile(String name, Exception e) {
        KeyedMessage message = this.i18nService.getKeyedText("stash.service.user.profile.cannotUpdate", "Could not update your profile", new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug(name + " could not update their own profile", (Throwable)e);
        }
        throw new ServerException(message, (Throwable)e);
    }

    private ServerException cannotUpdatePassword(String username, Exception e) {
        KeyedMessage message = this.i18nService.getKeyedText("stash.service.user.password.canNotUpdate", "Could not update password for {0}", new Object[]{username});
        if (log.isDebugEnabled()) {
            log.debug("The password for " + username + " could not be updated", (Throwable)e);
        }
        throw new ServerException(message, (Throwable)e);
    }

    private ServerException cannotUpdateProfile(User user, Exception e) {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && StringUtils.equals((String)currentUser.getName(), (String)user.getName())) {
            throw this.cannotUpdateOwnProfile(user.getName(), e);
        }
        throw this.cannotUpdateOtherProfile(user.getName(), e);
    }

    private AuthenticationSystemException crowdFailed(Exception e) {
        if (log.isDebugEnabled()) {
            log.debug("A Crowd request failed with an unexpected exception type", (Throwable)e);
        }
        throw new AuthenticationSystemException(this.i18nService.getKeyedText("stash.service.crowd.failed", "Crowd could not service the request.", new Object[0]), (Throwable)e);
    }

    private <T> T execute(CrowdCallback<T> callback) {
        try {
            return callback.execute(this.crowdService);
        }
        catch (GroupNotFoundException e) {
            throw this.unknownGroup(e.getGroupName());
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            throw this.unknownUser(e.getUserName());
        }
        catch (CrowdRuntimeException e) {
            throw this.crowdFailed((Exception)((Object)e));
        }
        catch (com.atlassian.crowd.exception.GroupNotFoundException e) {
            throw this.unknownGroup(e.getGroupName());
        }
        catch (UserNotFoundException e) {
            throw this.unknownUser(e.getUserName());
        }
        catch (CrowdException e) {
            throw this.crowdFailed((Exception)((Object)e));
        }
    }

    private KeyedMessage expiredCredentials() {
        return this.i18nService.getKeyedText("stash.service.user.expiredcredentials", "Your credentials have expired.", new Object[0]);
    }

    private <T> Page<T> getQueryPage(Query<T> query, PageRequest pageRequest) {
        return PageUtils.createPage(this.search(query), (PageRequest)pageRequest);
    }

    private KeyedMessage inactiveAccount() {
        return this.i18nService.getKeyedText("stash.service.user.inactive", "Your account has been de-activated.", new Object[0]);
    }

    private KeyedMessage noAccountDetails(String username) {
        return this.i18nService.getKeyedText("stash.service.user.nodetails", "User account details could not be retrieved for {0}.", new Object[]{username});
    }

    private NoSuchGroupException unknownGroup(String groupName) {
        throw new NoSuchGroupException(this.i18nService.getKeyedText("stash.service.group.unknown", "Could not find a group named {0}.", new Object[]{groupName}), groupName);
    }

    private NoSuchUserException unknownUser(String username) {
        throw new NoSuchUserException(this.i18nService.getKeyedText("stash.service.user.unknown", "Could not find a user named {0}.", new Object[]{username}), username);
    }

    private static abstract class VoidCrowdCallback
    implements CrowdCallback<Void> {
        private VoidCrowdCallback() {
        }

        @Override
        public Void execute(CrowdService crowdService) throws CrowdException {
            this.internalExecute(crowdService);
            return null;
        }

        protected abstract void internalExecute(CrowdService var1) throws CrowdException;
    }

    private static interface CrowdCallback<T> {
        public T execute(CrowdService var1) throws CrowdException;
    }
}

