/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.stash.internal.ApplicationConstants;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoizingApplicationFactory
implements ApplicationFactory {
    private static final Logger log = LoggerFactory.getLogger(MemoizingApplicationFactory.class);
    private final ApplicationDAO applicationDao;
    private final Supplier<Long> applicationId;

    public MemoizingApplicationFactory(final ApplicationDAO applicationDao) {
        this.applicationDao = applicationDao;
        this.applicationId = Suppliers.memoize((Supplier)new Supplier<Long>(){

            public Long get() {
                try {
                    return applicationDao.findByName(ApplicationConstants.CROWD_APPLICATION_NAME).getId();
                }
                catch (ApplicationNotFoundException e) {
                    return null;
                }
            }
        });
    }

    public Application getApplication() {
        Application application = null;
        try {
            Long id = (Long)this.applicationId.get();
            if (id != null) {
                application = this.applicationDao.findById(id.longValue());
            }
        }
        catch (ApplicationNotFoundException e) {
            log.debug("Crowd application : " + ApplicationConstants.CROWD_APPLICATION_NAME + " not found.");
        }
        return application;
    }
}

