/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.content.Blame;
import com.atlassian.stash.content.ContentService;
import com.atlassian.stash.content.ContentTreeCallback;
import com.atlassian.stash.content.ContentTreeNode;
import com.atlassian.stash.content.DiffContentCallback;
import com.atlassian.stash.content.DiffRequest;
import com.atlassian.stash.content.FileContentCallback;
import com.atlassian.stash.exception.CommandException;
import com.atlassian.stash.exception.NoSuchPathException;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.io.TypeAwareOutputSupplier;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.BlameCommandParameters;
import com.atlassian.stash.scm.Command;
import com.atlassian.stash.scm.DiffCommandParameters;
import com.atlassian.stash.scm.DirectoryCommandParameters;
import com.atlassian.stash.scm.FileCommandParameters;
import com.atlassian.stash.scm.RawFileCommandParameters;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.TypeCommandParameters;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ContentService.class)
@PreAuthorize(value="isRepositoryAccessible(#repository)")
@Service(value="contentService")
public class ContentServiceImpl
extends AbstractScmService
implements ContentService {
    public static final String DIFF_CONTEXT_LINES = "${changeset.diff.context}";
    public static final String MAX_SOURCE_LINE_LENGTH = "${page.max.source.length}";
    private static final Logger log = LoggerFactory.getLogger(ContentServiceImpl.class);
    private final I18nService i18nService;
    @Value(value="${changeset.diff.context}")
    private int diffContext;
    @Value(value="${page.max.diff.lines}")
    private int maxDiffLines;
    @Value(value="${page.max.directory.children}")
    private int maxDirectoryChildren;
    @Value(value="${page.max.directory.recursive.children}")
    private int maxDirectoryRecursiveChildren;
    @Value(value="${page.max.source.length}")
    private int maxLineLength;
    @Value(value="${page.max.source.lines}")
    private int maxSourceLines;

    @Autowired
    public ContentServiceImpl(ScmService scmService, I18nService i18nService) {
        super(scmService);
        this.i18nService = i18nService;
    }

    @Nonnull
    public List<Blame> getBlame(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nonnull PageRequest pageRequest) {
        List blame = (List)this.getCommandFactory(repository).blame(((BlameCommandParameters.Builder)((BlameCommandParameters.Builder)new BlameCommandParameters.Builder().changesetId(objectId)).path(path)).build(), pageRequest).call();
        return blame == null ? Collections.emptyList() : blame;
    }

    @Nonnull
    public ContentTreeNode.Type getType(@Nonnull Repository repository, @Nonnull String objectId, String path) {
        ContentTreeNode.Type type = (ContentTreeNode.Type)this.getCommandFactory(repository).type(((TypeCommandParameters.Builder)((TypeCommandParameters.Builder)new TypeCommandParameters.Builder().changesetId(objectId)).path(path)).build()).call();
        if (type == null) {
            throw new NoSuchPathException(this.i18nService.getKeyedText("stash.service.content.type.none", "The path {0} does not exist at revision {1}", new Object[]{path, objectId}), path, objectId);
        }
        return type;
    }

    public void streamDiff(@Nonnull Repository repository, String sinceId, @Nonnull String untilId, @Nonnull String path, @Nonnull DiffContentCallback callback) {
        List<String> paths = StringUtils.isBlank((String)path) ? Collections.emptyList() : Collections.singletonList(path);
        this.streamDiff(repository, sinceId, untilId, paths, callback);
    }

    public void streamDiff(Repository repository, String sinceId, String untilId, Iterable<String> paths, DiffContentCallback callback) {
        this.streamDiff(new DiffRequest.Builder(repository, untilId).sinceId(sinceId).paths(paths).build(), callback);
    }

    public void streamDiff(@Nonnull DiffRequest request, @Nonnull DiffContentCallback callback) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)request, (Object)"callback");
        DiffCommandParameters parameters = ((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(this.maxDiffLines)).paths((Iterable)request.getPaths())).sinceId(request.getSinceId()).untilId(request.getUntilId()).whitespace(request.getWhitespace())).build();
        Repository repository = request.getRepository();
        Command command = this.getCommandFactory(repository).diff(parameters, callback);
        try {
            command.call();
        }
        catch (CommandException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            StringBuilder builder = new StringBuilder("Error occurred when streaming diff in repository '").append(repository.getName()).append("' from revision '").append(request.getSinceId()).append("' to revision '").append(request.getUntilId()).append("'");
            if (request.getPaths().size() > 0) {
                builder.append(" for path(s) '").append(Iterables.toString((Iterable)request.getPaths()));
            }
            log.error(builder.toString(), rootCause);
            throw this.unexpectedError(rootCause);
        }
    }

    public void streamDirectory(@Nonnull Repository repository, @Nonnull String objectId, String path, boolean recursive, @Nonnull ContentTreeCallback callback, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(recursive ? this.maxDirectoryRecursiveChildren : this.maxDirectoryChildren);
        DirectoryCommandParameters parameters = ((DirectoryCommandParameters.Builder)((DirectoryCommandParameters.Builder)new DirectoryCommandParameters.Builder().changesetId(objectId)).path(path)).recurse(recursive).build();
        this.getCommandFactory(repository).directory(parameters, callback, pageRequest).call();
    }

    public void streamFile(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nonnull PageRequest pageRequest, boolean withBlame, @Nonnull FileContentCallback callback) throws ServiceException {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxSourceLines);
        FileCommandParameters parameters = ((FileCommandParameters.Builder)((FileCommandParameters.Builder)new FileCommandParameters.Builder().annotate(withBlame).changesetId(objectId)).maxLineLength(this.maxLineLength).path(path)).build();
        Command command = this.getCommandFactory(repository).file(parameters, callback, pageRequest);
        try {
            command.call();
        }
        catch (CommandException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            StringBuilder builder = new StringBuilder("Error occurred when streaming file in repository '").append(repository.getName()).append("' at revision '").append(objectId).append("' for path '").append(path);
            log.error(builder.toString(), rootCause);
            throw this.unexpectedError(rootCause);
        }
    }

    public void streamFile(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nonnull TypeAwareOutputSupplier outputStreamSupplier) throws ServiceException {
        RawFileCommandParameters parameters = ((RawFileCommandParameters.Builder)((RawFileCommandParameters.Builder)new RawFileCommandParameters.Builder().changesetId(objectId)).path(path)).build();
        this.getCommandFactory(repository).rawFile(parameters, outputStreamSupplier).call();
    }

    private ServerException unexpectedError(Throwable cause) {
        KeyedMessage message = this.i18nService.getKeyedText("stash.service.unexpected", "An unexpected error occurred while processing your request. Additional information may be available in the server's logs.", new Object[0]);
        throw new ServerException(message, cause);
    }
}

