/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.InternalLockService;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.util.Operation;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;

@Service(value="lockService")
public class DefaultLockService
implements InternalLockService {
    private final Map<Class<?>, Map<Long, WeakReference<ReentrantLock>>> locks;
    private final PlatformTransactionManager transactionManager;

    @Autowired
    public DefaultLockService(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.locks = ImmutableMap.builder().put(InternalRepository.class, (Object)Maps.newHashMap()).put(InternalPullRequest.class, (Object)Maps.newHashMap()).build();
    }

    public <T, E extends Exception> T doWithLock(@Nonnull InternalPullRequest pullRequest, @Nonnull Operation<T, E> operation) throws E {
        return this.doWithLock(pullRequest, operation, null);
    }

    public <T, E extends Exception> T doWithLock(@Nonnull InternalPullRequest pullRequest, @Nonnull Operation<T, E> operation, Propagation propagation) throws E {
        return this.doWithLock(this.getLock(InternalPullRequest.class, pullRequest.getGlobalId()), operation, propagation);
    }

    public <T, E extends Exception> T doWithLock(@Nonnull InternalRepository repository, @Nonnull Operation<T, E> operation) throws E {
        return this.doWithLock(repository, operation, null);
    }

    public <T, E extends Exception> T doWithLock(@Nonnull InternalRepository repository, @Nonnull Operation<T, E> operation, Propagation propagation) throws E {
        return this.doWithLock(this.getLock(InternalRepository.class, repository.getId().intValue()), operation, propagation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Exception> T doWithLock(ReentrantLock lock, Operation<T, E> operation, Propagation propagation) throws E {
        if (propagation == null) {
            propagation = Propagation.SUPPORTS;
        }
        TransactionStatus txStatus = null;
        lock.lock();
        try {
            txStatus = this.transactionManager.getTransaction(SpringTransactionUtils.definitionFor((int)propagation.value()));
            Object result = operation.perform();
            this.transactionManager.commit(txStatus);
            txStatus = null;
            Object object = result;
            return (T)object;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            this.transactionManager.commit(txStatus);
            txStatus = null;
            throw e;
        }
        finally {
            try {
                if (txStatus != null) {
                    this.transactionManager.rollback(txStatus);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private synchronized ReentrantLock getLock(Class<?> clazz, long id) {
        ReentrantLock lock;
        Map<Long, WeakReference<ReentrantLock>> classLocks = this.locks.get(clazz);
        WeakReference<ReentrantLock> reference = classLocks.get(id);
        ReentrantLock reentrantLock = lock = reference == null ? null : (ReentrantLock)reference.get();
        if (lock == null) {
            lock = new ReentrantLock();
            classLocks.put(id, new WeakReference<ReentrantLock>(lock));
        }
        return lock;
    }
}

