/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.avatar.AvatarService;
import com.atlassian.stash.avatar.AvatarStoreException;
import com.atlassian.stash.avatar.AvatarSupplier;
import com.atlassian.stash.avatar.CacheableAvatarSupplier;
import com.atlassian.stash.avatar.SimpleAvatarSupplier;
import com.atlassian.stash.event.ProjectDeletedEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.avatar.AvatarRepository;
import com.atlassian.stash.internal.avatar.AvatarSource;
import com.atlassian.stash.internal.avatar.AvatarType;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectVisitor;
import com.atlassian.stash.user.AvatarRequest;
import com.atlassian.stash.user.Person;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={AvatarService.class, com.atlassian.stash.user.AvatarService.class})
@Service(value="avatarService")
@Transactional(propagation=Propagation.SUPPORTS)
public class ConfigurableAvatarService
extends AbstractService
implements InternalAvatarService {
    public static final String DEFAULT_SOURCE = "default";
    public static final String DISABLED_SOURCE = "disabled";
    private static final Pattern PATTERN_DATA_URI = Pattern.compile("data:([^;]+);base64,([A-Za-z0-9+/]+)=*$");
    private final AtomicReference<AvatarSource> activeSource;
    private final AvatarSource defaultSource;
    private final AvatarSource disabledSource;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final InternalApplicationPropertiesService propertiesService;
    private final AvatarRepository repository;

    @Autowired
    public ConfigurableAvatarService(I18nService i18nService, NavBuilder navBuilder, InternalApplicationPropertiesService propertiesService, AvatarRepository repository, @Qualifier(value="urlAvatarSource") AvatarSource defaultSource, @Qualifier(value="webResourceAvatarSource") AvatarSource disabledSource) {
        this.defaultSource = defaultSource;
        this.disabledSource = disabledSource;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.propertiesService = propertiesService;
        this.repository = repository;
        this.activeSource = DISABLED_SOURCE.equals(propertiesService.getAvatarSource()) ? new AtomicReference<AvatarSource>(disabledSource) : new AtomicReference<AvatarSource>(defaultSource);
    }

    @Nonnull
    @Unsecured(value="Creating a supplier from a data URI requires no specific permission")
    public AvatarSupplier createSupplierFromDataUri(@Nonnull String uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri");
        uri = uri.replaceAll("\\s", "").replace('-', '+').replace('_', '/');
        Matcher matcher = PATTERN_DATA_URI.matcher(uri);
        if (!matcher.matches()) {
            throw new AvatarStoreException(this.i18nService.getKeyedText("stash.service.avatar.invaliddatauri", "The data URI provided to supply avatar data is invalid. The data URI is required to contain Base64-encoded image data, and may not use \"URL-safe\" encoding.", new Object[0]));
        }
        String contentType = matcher.group(1);
        String data = matcher.group(2);
        ByteArrayInputStream base64Data = new ByteArrayInputStream(StringUtils.getBytesUtf8((String)data));
        return new SimpleAvatarSupplier(contentType, (InputStream)new Base64InputStream((InputStream)base64Data));
    }

    @PreAuthorize(value="isAuthenticated()")
    public void deleteTemporary(@Nonnull String id) {
        this.repository.deleteTemporary(id);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getForProject(@Nonnull Project project, int size) {
        Preconditions.checkArgument((((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId() != null ? 1 : 0) != 0, (Object)"The provided project has not been persisted; avatars may not be retrieved for transient projects");
        return this.repository.load(AvatarType.PROJECT, (Object)project.getId(), size);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getUrlForPerson(@Nonnull Person person, @Nonnull AvatarRequest request) {
        Preconditions.checkNotNull((Object)person, (Object)"person");
        Preconditions.checkNotNull((Object)request, (Object)"request");
        com.atlassian.stash.avatar.AvatarRequest translatedRequest = request instanceof com.atlassian.stash.avatar.AvatarRequest ? (com.atlassian.stash.avatar.AvatarRequest)request : new com.atlassian.stash.avatar.AvatarRequest(request.isSecure(), request.getSize(), request.isUseConfigured());
        return this.activeSource.get().getUrlForPerson(person, translatedRequest);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getUrlForProject(@Nonnull Project project, @Nonnull com.atlassian.stash.avatar.AvatarRequest request) {
        return (String)((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).accept((ProjectVisitor)new AvatarProjectVisitor(request));
    }

    @Unsecured(value="Anyone is allowed to check whether avatars are enabled")
    public boolean isEnabled() {
        return this.activeSource.get() == this.defaultSource;
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) {
        this.repository.cleanup(AvatarType.PROJECT, (Object)event.getProject().getId());
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public AvatarSupplier readTemporary(@Nonnull String id) {
        return this.repository.loadTemporary(id);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void saveForProject(@Nonnull Project project, @Nonnull AvatarSupplier supplier) {
        Preconditions.checkArgument((((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId() != null ? 1 : 0) != 0, (Object)"The provided project has not been persisted; avatars may not be stored for transient projects");
        this.repository.store(AvatarType.PROJECT, (Object)project.getId(), supplier);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public String saveTemporary(@Nonnull AvatarSupplier supplier) {
        return this.repository.storeTemporary(supplier);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setEnabled(boolean enabled) {
        this.propertiesService.setAvatarSource(enabled ? DEFAULT_SOURCE : DISABLED_SOURCE);
        if (enabled) {
            this.activeSource.compareAndSet(this.disabledSource, this.defaultSource);
        } else {
            this.activeSource.compareAndSet(this.defaultSource, this.disabledSource);
        }
    }

    private class AvatarProjectVisitor
    implements ProjectVisitor<String> {
        private final com.atlassian.stash.avatar.AvatarRequest request;

        private AvatarProjectVisitor(com.atlassian.stash.avatar.AvatarRequest request) {
            this.request = (com.atlassian.stash.avatar.AvatarRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        }

        public String visit(@Nonnull Project project) {
            NavBuilder.Builder builder = ConfigurableAvatarService.this.navBuilder.project(project).avatar(this.request.getSize());
            return this.request.isUseConfigured() ? builder.buildConfigured() : builder.buildRelative();
        }

        public String visit(@Nonnull PersonalProject project) {
            return ConfigurableAvatarService.this.getUrlForPerson((Person)project.getOwner(), (AvatarRequest)this.request);
        }
    }
}

