/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.trusted;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.security.auth.trustedapps.Application;
import com.atlassian.security.auth.trustedapps.ApplicationRetriever;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultCurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultTrustedApplication;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.RequestConditions;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsConfigurationManager;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.stash.Product;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.auth.trusted.CurrentApplicationDao;
import com.atlassian.stash.internal.auth.trusted.InternalCurrentApplication;
import com.atlassian.stash.internal.auth.trusted.InternalTrustedApplication;
import com.atlassian.stash.internal.auth.trusted.TrustedApplicationDao;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="trustedApplicationsManager")
@AvailableToPlugins(interfaces={TrustedApplicationsManager.class, TrustedApplicationsConfigurationManager.class})
@Transactional
public class TrustedApplicationsManagerImpl
implements ApplicationListener<ContextRefreshedEvent>,
TrustedApplicationsManager,
TrustedApplicationsConfigurationManager {
    private final EncryptionProvider encryptionProvider;
    private final TrustedApplicationDao trustedApplicationDao;
    private final CurrentApplicationDao currentApplicationDao;
    private static final Logger log = LoggerFactory.getLogger(TrustedApplicationsManagerImpl.class);
    private final Function<InternalTrustedApplication, TrustedApplication> toTrustedApplication = new Function<InternalTrustedApplication, TrustedApplication>(){

        public TrustedApplication apply(InternalTrustedApplication input) {
            if (input != null) {
                try {
                    return new DefaultTrustedApplication(TrustedApplicationsManagerImpl.this.encryptionProvider, TrustedApplicationsManagerImpl.this.encryptionProvider.toPublicKey(input.getPublicKey()), input.getApplicationId(), RequestConditions.builder().addIPPattern((String[])Iterables.toArray((Iterable)input.getIPPatterns(), String.class)).addURLPattern((String[])Iterables.toArray((Iterable)input.getUrlPatterns(), String.class)).setCertificateTimeout(input.getCertificateTimeout()).build());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvalidKeySpecException e) {
                    throw new IllegalStateException(e);
                }
                catch (NoSuchProviderException e) {
                    throw new IllegalStateException(e);
                }
            }
            return null;
        }
    };

    @Autowired
    public TrustedApplicationsManagerImpl(EncryptionProvider encryptionProvider, TrustedApplicationDao trustedApplicationDao, CurrentApplicationDao currentApplicationDao) {
        this.encryptionProvider = encryptionProvider;
        this.trustedApplicationDao = trustedApplicationDao;
        this.currentApplicationDao = currentApplicationDao;
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public TrustedApplication addTrustedApplication(Application app, RequestConditions conditions) {
        InternalTrustedApplication application = this.trustedApplicationDao.getByApplicationId(app.getID());
        InternalTrustedApplication.Builder builder = application == null ? new InternalTrustedApplication.Builder().applicationId(app.getID()).publicKey(app.getPublicKey().getEncoded()) : application.copy();
        if (conditions != null) {
            builder.certificateTimeout(conditions.getCertificateTimeout());
            builder.ipPatterns(conditions.getIPPatterns());
            builder.urlPatterns(conditions.getURLPatterns());
        }
        application = application == null ? (InternalTrustedApplication)this.trustedApplicationDao.create((Object)builder.build()) : (InternalTrustedApplication)this.trustedApplicationDao.update((Object)builder.build());
        return (TrustedApplication)this.toTrustedApplication.apply((Object)application);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public boolean deleteApplication(String id) {
        InternalTrustedApplication application = this.trustedApplicationDao.getByApplicationId(id);
        if (application != null) {
            this.trustedApplicationDao.delete((Object)application);
        }
        return application != null;
    }

    @Transactional(readOnly=true)
    @Unsecured(value="harmless utility method for retrieving public remote certificates")
    public Iterable<TrustedApplication> getTrustedApplications() {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.trustedApplicationDao.findAll(), this.toTrustedApplication));
    }

    @Transactional(readOnly=true)
    @Unsecured(value="harmless utility method for retrieving public remote certificates")
    public TrustedApplication getTrustedApplication(String id) {
        return (TrustedApplication)this.toTrustedApplication.apply((Object)this.trustedApplicationDao.getByApplicationId(id));
    }

    @Unsecured(value="harmless utility method for retrieving public remote certificates")
    public CurrentApplication getCurrentApplication() {
        InternalCurrentApplication internalCurrentApplication = this.getInternalCurrentApplication();
        try {
            return new DefaultCurrentApplication(this.encryptionProvider, this.encryptionProvider.toPublicKey(internalCurrentApplication.getPublicKey()), this.encryptionProvider.toPrivateKey(internalCurrentApplication.getPrivateKey()), internalCurrentApplication.getApplicationId());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException(e);
        }
    }

    @Unsecured(value="harmless utility method for retrieving public remote certificates")
    public Application getApplicationCertificate(String baseUrl) throws ApplicationRetriever.RetrievalException {
        return this.encryptionProvider.getApplicationCertificate(baseUrl);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Page all = this.currentApplicationDao.findAll((PageRequest)new PageRequestImpl(0, 1));
        if (!all.getIsLastPage()) {
            log.warn("Multiple certificates found for this {} instance: please see https://confluence.atlassian.com/x/awiaEQ", (Object)Product.NAME);
        } else if (all.getSize() == 0) {
            this.getInternalCurrentApplication();
        }
    }

    private InternalCurrentApplication getInternalCurrentApplication() {
        InternalCurrentApplication currentApplication = this.currentApplicationDao.get();
        if (currentApplication == null) {
            KeyPair keyPair;
            try {
                keyPair = this.encryptionProvider.generateNewKeyPair();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
            catch (NoSuchProviderException e) {
                throw new IllegalStateException(e);
            }
            currentApplication = new InternalCurrentApplication(this.encryptionProvider.generateUID(), keyPair.getPublic().getEncoded(), keyPair.getPrivate().getEncoded());
            currentApplication = (InternalCurrentApplication)this.currentApplicationDao.create((Object)currentApplication);
        }
        return currentApplication;
    }
}

