/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.trusted;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.types.TrustedAppsAuthenticationProvider;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.stash.internal.auth.trusted.CurrentApplicationDao;
import com.atlassian.stash.internal.auth.trusted.InternalCurrentApplication;
import com.atlassian.stash.internal.auth.trusted.TrustedApplicationDao;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class CorruptedAppLinkRemover {
    private static final Predicate<InternalCurrentApplication> CORRUPTED_KEY = new Predicate<InternalCurrentApplication>(){

        public boolean apply(InternalCurrentApplication app) {
            return app.getPrivateKey().length < 20 || app.getPublicKey().length < 20;
        }
    };
    private final TrustedApplicationsManager trustedApplicationsManager;
    private final TrustedApplicationDao trustedApplicationDao;
    private final CurrentApplicationDao currentApplicationDao;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final PlatformTransactionManager platformTransactionManager;
    private final MutatingApplicationLinkService applicationLinkService;
    private final SecurityService securityService;
    private static final Logger log = LoggerFactory.getLogger(CorruptedAppLinkRemover.class);
    private final UncheckedOperation<Void> cleanupOperation = new UncheckedOperation<Void>(){

        public Void perform() {
            Page apps = CorruptedAppLinkRemover.this.currentApplicationDao.findAll((PageRequest)new PageRequestImpl(0, 2000));
            ArrayList corruptedCurrentApps = Lists.newArrayList((Iterable)Iterables.filter((Iterable)apps.getValues(), (Predicate)CORRUPTED_KEY));
            if (!corruptedCurrentApps.isEmpty()) {
                log.warn("Attempting to clean up corrupted application links. For more information, see https://confluence.atlassian.com/x/EwDSEQ");
                CorruptedAppLinkRemover.this.unregisterAllTrustedAppLinks();
                CorruptedAppLinkRemover.this.trustedApplicationDao.deleteAll();
                CorruptedAppLinkRemover.this.deleteCurrentApps(corruptedCurrentApps);
                if (apps.getSize() == corruptedCurrentApps.size()) {
                    CorruptedAppLinkRemover.this.trustedApplicationsManager.getCurrentApplication();
                }
                log.warn("Finished attempt to clean up corrupted application links");
            }
            return null;
        }
    };
    private final Predicate<ApplicationLink> trustedLink = new Predicate<ApplicationLink>(){

        public boolean apply(ApplicationLink appLink) {
            Class<TrustedAppsAuthenticationProvider> providerClass = TrustedAppsAuthenticationProvider.class;
            return CorruptedAppLinkRemover.this.authenticationConfigurationManager.isConfigured(appLink.getId(), providerClass);
        }
    };

    @Autowired
    public CorruptedAppLinkRemover(TrustedApplicationsManager trustedApplicationsManager, TrustedApplicationDao trustedApplicationDao, CurrentApplicationDao currentApplicationDao, AuthenticationConfigurationManager authenticationConfigurationManager, MutatingApplicationLinkService applicationLinkService, PlatformTransactionManager platformTransactionManager, SecurityService securityService) {
        this.trustedApplicationsManager = trustedApplicationsManager;
        this.trustedApplicationDao = trustedApplicationDao;
        this.currentApplicationDao = currentApplicationDao;
        this.applicationLinkService = applicationLinkService;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.platformTransactionManager = platformTransactionManager;
        this.securityService = securityService;
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        new TransactionTemplate(this.platformTransactionManager).execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                String reason = "Clean up corrupted application links";
                return CorruptedAppLinkRemover.this.securityService.doWithPermission(reason, Permission.SYS_ADMIN, (Operation)CorruptedAppLinkRemover.this.cleanupOperation);
            }
        });
    }

    private void deleteCurrentApps(List<InternalCurrentApplication> currentApps) {
        for (InternalCurrentApplication app : currentApps) {
            this.currentApplicationDao.delete((Object)app);
        }
    }

    private void unregisterAllTrustedAppLinks() {
        Iterable applicationLinks = this.applicationLinkService.getApplicationLinks();
        Iterable trustedAppLinks = Iterables.filter((Iterable)applicationLinks, this.trustedLink);
        for (ApplicationLink appLink : trustedAppLinks) {
            String appLinkName = appLink.getName();
            URI appLinkRpcUrl = appLink.getRpcUrl();
            try {
                this.applicationLinkService.deleteApplicationLink(appLink);
                log.warn("Deleted application link named {} with RPC url {}", (Object)appLinkName, (Object)appLinkRpcUrl);
            }
            catch (Exception e) {
                log.warn("Failed to delete application link named {} with RPC url {}", (Object)appLinkName, (Object)appLinkRpcUrl);
            }
        }
    }
}

