/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.stash.Product;
import com.atlassian.stash.auth.HttpAuthenticationFailureContext;
import com.atlassian.stash.auth.HttpAuthenticationFailureHandler;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.scm.AuthenticationState;
import com.atlassian.stash.scm.HttpScmRequestProvider;
import com.atlassian.stash.scm.http.HttpScmRequest;
import com.atlassian.stash.util.RequestUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ScmAuthenticationFailureHandler
implements HttpAuthenticationFailureHandler {
    public static final String SCM_SERVLET_PATH = "/scm";
    private final HttpScmRequestProvider httpScmRequestProvider;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;

    public ScmAuthenticationFailureHandler(HttpScmRequestProvider httpScmRequestProvider, I18nService i18nService, NavBuilder navBuilder) {
        this.httpScmRequestProvider = httpScmRequestProvider;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws IOException {
        String explanation;
        String title;
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        AuthenticationState authenticationState = context.getAuthenticationState();
        if (!SCM_SERVLET_PATH.equals(request.getServletPath())) {
            return false;
        }
        HttpScmRequest httpScmRequest = this.httpScmRequestProvider.getHttpScmRequest(request, response = RequestUtils.unwrap((HttpServletResponse)response));
        if (httpScmRequest == null) {
            return false;
        }
        switch (authenticationState) {
            case CAPTCHA_REQUIRED: {
                title = this.i18nService.getText("stash.scm.captcha.required", "CAPTCHA required", new Object[0]);
                explanation = this.i18nService.getText("stash.scm.captcha.required.detail", "Your {0} account has been marked as requiring a CAPTCHA to be solved before you may login again. This is typically caused by too many attempts to login with an incorrect password. The required CAPTCHA prevents your SCM client from accessing {0} until it is solved, even if you enter your password correctly.\n\nIf you are currently logged in to {0} via a browser you may need to logout and then log back in in order to clear the CAPTCHA.\n\nVisit {0} at {1} for more details.", new Object[]{Product.NAME, this.navBuilder.buildAbsolute()});
                break;
            }
            case UNLICENSED: {
                title = this.i18nService.getText("stash.scm.no.licensed.user", "Not licensed", new Object[0]);
                explanation = this.i18nService.getText("stash.scm.no.licensed.user.detail", "You do not have permission to access {0}.\nPlease contact your administrator to resolve this issue.", new Object[]{Product.NAME});
                break;
            }
            default: {
                title = this.i18nService.getText("stash.scm.no.authentication", "Not authenticated", new Object[0]);
                explanation = this.i18nService.getText("stash.scm.no.authentication.detail", "Authentication failed. Please check your credentials and try again.", new Object[0]);
            }
        }
        httpScmRequest.sendAuthenticationError(authenticationState, title, explanation);
        return true;
    }
}

