/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.stash.auth.HttpAuthenticationFailureContext;
import com.atlassian.stash.auth.HttpAuthenticationFailureHandler;
import com.atlassian.stash.nav.NavBuilder;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;

public class RedirectingAuthenticationFailureHandler
implements HttpAuthenticationFailureHandler {
    private final NavBuilder navBuilder;

    public RedirectingAuthenticationFailureHandler(NavBuilder navBuilder) {
        this.navBuilder = navBuilder;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws ServletException, IOException {
        if ("basic".equals(context.getMethod())) {
            return false;
        }
        String next = context.getRequest().getParameter("next");
        NavBuilder.Builder login = this.navBuilder.login();
        if (next != null) {
            login.withParam("next", next);
        }
        context.getResponse().sendRedirect(login.buildRelative());
        return true;
    }
}

