/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.auth.HttpAuthenticationSuccessContext;
import com.atlassian.stash.auth.HttpAuthenticationSuccessHandler;
import com.atlassian.stash.auth.HttpAuthenticationSuccessHandlerModuleDescriptor;
import com.atlassian.stash.event.AuthenticationSuccessEvent;
import com.atlassian.stash.util.ModuleDescriptorUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pluginHttpAuthenticationSuccessHandler")
public class PluginHttpAuthenticationSuccessHandler
implements HttpAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(PluginHttpAuthenticationSuccessHandler.class);
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginHttpAuthenticationSuccessHandler(EventPublisher eventPublisher, PluginAccessor pluginAccessor) {
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
    }

    public boolean onAuthenticationSuccess(@Nonnull HttpAuthenticationSuccessContext context) throws ServletException, IOException {
        String username = context.getUsername() != null ? context.getUsername() : context.getUser().getName();
        this.eventPublisher.publish((Object)new AuthenticationSuccessEvent((Object)this, username, context.getMethod()));
        for (HttpAuthenticationSuccessHandler handler : this.getHandlers()) {
            String handlerName = handler.getClass().getName();
            log.debug("onAuthenticationSuccess - delegating to {}", (Object)handlerName);
            if (!handler.onAuthenticationSuccess(context)) continue;
            log.debug("onAuthenticationSuccess - {} handled authentication success", (Object)handlerName);
            return true;
        }
        log.debug("onAuthenticationSuccess - none of the plugins handled authentication success");
        return false;
    }

    private Iterable<HttpAuthenticationSuccessHandler> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpAuthenticationSuccessHandlerModuleDescriptor.class));
    }
}

