/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.auth.HttpAuthenticationContext;
import com.atlassian.stash.auth.HttpAuthenticationHandler;
import com.atlassian.stash.auth.HttpAuthenticationHandlerModuleDescriptor;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.ModuleDescriptorUtils;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pluginHttpAuthenticationHandler")
public class PluginHttpAuthenticationHandler
implements HttpAuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(PluginHttpAuthenticationHandler.class);
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginHttpAuthenticationHandler(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StashUser authenticate(@Nonnull HttpAuthenticationContext context) {
        for (HttpAuthenticationHandler handler : this.getHandlers()) {
            String handlerName = handler.getClass().getName();
            Timer timer = TimerUtils.start((String)(handlerName + ".authentication"));
            try {
                log.debug("authenticate - trying handler {}", (Object)handlerName);
                StashUser user = handler.authenticate(context);
                if (user == null) continue;
                log.debug("authenticate - handler {} authenticated user {}", (Object)handlerName, (Object)user.getName());
                StashUser stashUser = user;
                return stashUser;
            }
            finally {
                timer.stop();
            }
        }
        log.debug("authenticate - none of the plugins handled authentication");
        return null;
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext context) {
        for (HttpAuthenticationHandler handler : this.getHandlers()) {
            String handlerName = handler.getClass().getName();
            Timer timer = TimerUtils.start((String)(handlerName + ".validateAuthentication"));
            try {
                log.trace("validateAuthentication - Calling handler {}.validateAuthentication", (Object)handlerName);
                handler.validateAuthentication(context);
            }
            catch (RuntimeException e) {
                log.debug("validateAuthentication - Handler {} failed validation {}:{}", new Object[]{handlerName, e.getClass().getName(), e.getMessage()});
                throw e;
            }
            finally {
                timer.stop();
            }
        }
    }

    private Iterable<HttpAuthenticationHandler> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpAuthenticationHandlerModuleDescriptor.class));
    }
}

