/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.stash.auth.HttpAuthenticationContext;
import com.atlassian.stash.auth.HttpAuthenticationHandler;
import com.atlassian.stash.exception.NoSuchUserException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.user.IncorrectPasswordAuthenticationException;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import javax.annotation.Nonnull;

public class EmbeddedCrowdHttpAuthenticationHandler
implements HttpAuthenticationHandler {
    private final I18nService i18nService;
    private final UserService userService;

    public EmbeddedCrowdHttpAuthenticationHandler(I18nService i18nService, UserService userService) {
        this.i18nService = i18nService;
        this.userService = userService;
    }

    public StashUser authenticate(@Nonnull HttpAuthenticationContext authenticationContext) {
        String username = authenticationContext.getUsername();
        Object password = authenticationContext.getCredentials();
        if (username == null && !(password instanceof String)) {
            return null;
        }
        if (username != null && password instanceof String) {
            try {
                return this.userService.authenticate(username, (String)password);
            }
            catch (NoSuchUserException e) {
                throw this.newBadCredentials();
            }
            catch (IncorrectPasswordAuthenticationException e) {
                throw this.newBadCredentials();
            }
        }
        throw this.newBadCredentials();
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
    }

    private IncorrectPasswordAuthenticationException newBadCredentials() {
        throw new IncorrectPasswordAuthenticationException(this.i18nService.getKeyedText("stash.auth.failed", "Invalid username or password.", new Object[0]));
    }
}

