/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.stash.internal.auth.AuthenticationHelper;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Component;

@Component(value="authenticationHelper")
public class DefaultAuthenticationHelper
implements AuthenticationHelper {
    static final String ATTR_AUTHENTICATION_FAILED = "stash.auth.failed";
    static final String ATTR_CACHED_USERNAME = "stash.cached-username";

    public String getCachedUsername(@Nonnull HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session == null ? null : (String)session.getAttribute(ATTR_CACHED_USERNAME);
    }

    public boolean isAuthenticationFailed(@Nonnull HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session != null && session.getAttribute(ATTR_AUTHENTICATION_FAILED) != null;
    }

    public void setAuthenticationFailed(@Nonnull HttpServletRequest request, boolean failed) {
        if (failed) {
            request.getSession(true).setAttribute(ATTR_AUTHENTICATION_FAILED, (Object)Boolean.TRUE);
        } else {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute(ATTR_AUTHENTICATION_FAILED);
            }
        }
    }

    public void setCachedUsername(@Nonnull HttpServletRequest request, @Nonnull String username) {
        request.getSession(true).setAttribute(ATTR_CACHED_USERNAME, (Object)username);
    }
}

