/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.auth.AuthenticationFailureHandler;
import com.atlassian.stash.auth.AuthenticationFailureHandlerModuleDescriptor;
import com.atlassian.stash.auth.HttpAuthenticationFailureContext;
import com.atlassian.stash.auth.HttpAuthenticationFailureHandler;
import com.atlassian.stash.util.ModuleDescriptorUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;

public class BridgingAuthenticationFailureHandler
implements HttpAuthenticationFailureHandler {
    private final PluginAccessor pluginAccessor;

    public BridgingAuthenticationFailureHandler(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws ServletException, IOException {
        if ("basic".equals(context.getMethod())) {
            for (AuthenticationFailureHandler handler : this.getFailureHandlers()) {
                if (!handler.handleAuthenticationFailure(context.getAuthenticationState(), context.getRequest(), context.getResponse())) continue;
                return true;
            }
        }
        return false;
    }

    private Iterable<AuthenticationFailureHandler> getFailureHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(AuthenticationFailureHandlerModuleDescriptor.class));
    }
}

