/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.stash.Product;
import com.atlassian.stash.auth.HttpAuthenticationFailureContext;
import com.atlassian.stash.auth.HttpAuthenticationFailureHandler;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.scm.AuthenticationState;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;

public class BasicAuthChallengeFailureHandler
implements HttpAuthenticationFailureHandler {
    private final I18nService i18nService;

    public BasicAuthChallengeFailureHandler(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws ServletException, IOException {
        if (!"basic".equals(context.getMethod())) {
            return false;
        }
        HttpServletResponse response = context.getResponse();
        response.addHeader("WWW-Authenticate", "Basic realm=\"" + Product.FULL_NAME + "\"");
        response.sendError(401, this.getMessage(context.getAuthenticationState()));
        return true;
    }

    private String getMessage(AuthenticationState reason) {
        switch (reason) {
            case CAPTCHA_REQUIRED: {
                return this.i18nService.getText("stash.auth.failed.captcha.required", "To proceed you must first re-authenticate with {0} via the web interface", new Object[]{Product.NAME});
            }
            case UNLICENSED: {
                return this.i18nService.getText("stash.auth.failed.unlicensed.user", "You do not have permission to access {0}.\nPlease contact your administrator to resolve this issue.", new Object[]{Product.NAME});
            }
        }
        return this.i18nService.getText("stash.auth.failed.credentials", "Authentication failed. Please check your credentials and try again.", new Object[0]);
    }
}

