/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.audit.AuditEntry;
import com.atlassian.stash.audit.Priority;
import com.atlassian.stash.event.AbstractRepositoryModificationEvent;
import com.atlassian.stash.event.RepositoryAccessedEvent;
import com.atlassian.stash.event.RepositoryCreatedEvent;
import com.atlassian.stash.event.RepositoryCreationFailedEvent;
import com.atlassian.stash.event.RepositoryDefaultBranchModifiedEvent;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.event.RepositoryDeletionRequestedEvent;
import com.atlassian.stash.event.RepositoryEvent;
import com.atlassian.stash.event.RepositoryModificationRequestedEvent;
import com.atlassian.stash.event.RepositoryModifiedEvent;
import com.atlassian.stash.event.RepositoryOtherReadEvent;
import com.atlassian.stash.event.RepositoryOtherWriteEvent;
import com.atlassian.stash.event.RepositoryPullEvent;
import com.atlassian.stash.event.RepositoryPushEvent;
import com.atlassian.stash.event.StashEvent;
import com.atlassian.stash.event.hook.RepositoryHookEvent;
import com.atlassian.stash.event.hook.RepositoryHookSettingsChangedEvent;
import com.atlassian.stash.internal.audit.AbstractAuditEventListener;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryEventListener
extends AbstractAuditEventListener {
    @Autowired
    public RepositoryEventListener(AuditEntryLoggingService auditLoggingService, RequestManager requestManager, StashAuthenticationContext authContext, EventPublisher eventPublisher) {
        super(auditLoggingService, requestManager, authContext, eventPublisher);
    }

    @EventListener
    public void onRepositoryModificationRequested(RepositoryModificationRequestedEvent event) throws Exception {
        this.auditRepositoryModificationEvent((AbstractRepositoryModificationEvent)event, Collections.<String>emptySet(), Priority.LOW);
    }

    @EventListener
    public void onRepositoryModified(RepositoryModifiedEvent event) throws Exception {
        this.auditRepositoryModificationEvent((AbstractRepositoryModificationEvent)event, Sets.newHashSet((Object[])new String[]{"audit.channel.ui.repository"}), Priority.HIGH);
    }

    @EventListener
    public void onRepositoryAccessed(RepositoryAccessedEvent event) throws Exception {
        this.auditRepositoryEvent((RepositoryEvent)event);
    }

    @EventListener
    public void onRepositoryCreated(RepositoryCreatedEvent event) throws Exception {
        ImmutableMap.Builder<String, Object> builder = RepositoryEventListener.getMapBuilder();
        Repository repository = event.getRepository();
        RepositoryEventListener.addProjectAndRepositoryToMap(repository, builder);
        if (repository.getOrigin() != null) {
            builder.put((Object)"origin", RepositoryEventListener.toProjectAndRepositoryMap(repository.getOrigin()));
        }
        this.auditRepositoryEvent((RepositoryEvent)event, Sets.newHashSet((Object[])new String[]{"audit.channel.ui.project", "audit.channel.ui.repository"}), Priority.MEDIUM, this.convertToJsonString(builder.build()));
    }

    @EventListener
    public void onRepositoryCreationFailed(RepositoryCreationFailedEvent event) throws Exception {
        this.auditRepositoryEvent((RepositoryEvent)event);
    }

    @EventListener
    public void onRepositoryDefaultBranchModified(RepositoryDefaultBranchModifiedEvent event) throws Exception {
        this.auditRepositoryEvent((RepositoryEvent)event, Collections.<String>emptySet(), Priority.LOW, this.convertToJsonString(RepositoryEventListener.getMapBuilder().put((Object)"defaultBranch", (Object)event.getNewValue()).build()));
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) throws Exception {
        this.auditRepositoryEvent((RepositoryEvent)event, Sets.newHashSet((Object[])new String[]{"audit.channel.ui.project"}), Priority.HIGH, this.convertToJsonString(RepositoryEventListener.addProjectAndRepositoryToMap(event.getRepository(), RepositoryEventListener.getMapBuilder()).build()));
    }

    @EventListener
    public void onRepositoryDeletionRequested(RepositoryDeletionRequestedEvent event) throws Exception {
        this.auditRepositoryEvent((RepositoryEvent)event);
    }

    @EventListener
    public void onRepositoryOtherRead(RepositoryOtherReadEvent event) throws Exception {
        this.auditRepositoryEvent((RepositoryEvent)event);
    }

    @EventListener
    public void onRepositoryOtherWrite(RepositoryOtherWriteEvent event) throws Exception {
        this.auditRepositoryEvent((RepositoryEvent)event);
    }

    @EventListener
    public void onRepositoryPull(RepositoryPullEvent event) throws Exception {
        this.auditRepositoryEvent((RepositoryEvent)event);
    }

    @EventListener
    public void onRepositoryHook(RepositoryHookEvent event) throws Exception {
        if (event instanceof RepositoryHookSettingsChangedEvent) {
            this.auditRepositoryHookSettingsChanged((RepositoryHookSettingsChangedEvent)event);
            return;
        }
        AuditEntry auditEntry = this.createHookAuditEntryBuilder(event).build();
        this.publish(event, auditEntry, Sets.newHashSet((Object[])new String[]{"audit.channel.ui.repository"}), Priority.HIGH);
    }

    @EventListener
    public void onRepositoryPush(RepositoryPushEvent event) throws Exception {
        Repository repository = event.getRepository();
        AuditEntry auditEntry = this.createAuditEntryBuilder((StashEvent)event).target(RepositoryEventListener.toProjectAndRepositoryString(repository)).details(this.convertToJsonString(RepositoryEventListener.toMaps(event.getRefChanges()))).build();
        this.publish(event, auditEntry, Priority.LOW);
    }

    private static Map<String, Object> diffRepositories(Repository old, Repository updated) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!StringUtils.equals((String)old.getName(), (String)updated.getName())) {
            builder.put((Object)"old.name", (Object)old.getName());
            builder.put((Object)"new.name", (Object)updated.getName());
        }
        if (old.isForkable() != updated.isForkable()) {
            builder.put((Object)"old.isForkable", (Object)old.isForkable());
            builder.put((Object)"new.isForkable", (Object)updated.isForkable());
        }
        if (old.isPublic() != updated.isPublic()) {
            builder.put((Object)"old.isPublic", (Object)old.isPublic());
            builder.put((Object)"new.isPublic", (Object)updated.isPublic());
        }
        return builder.build();
    }

    private void auditRepositoryEvent(RepositoryEvent event) throws Exception {
        this.auditRepositoryEvent(event, Collections.<String>emptySet(), Priority.LOW, null);
    }

    private void auditRepositoryEvent(RepositoryEvent event, Set<String> channels, Priority priority, String details) throws Exception {
        Repository repository = event.getRepository();
        AuditEntry auditEntry = this.createAuditEntryBuilder((StashEvent)event).repository(repository).target(RepositoryEventListener.toProjectAndRepositoryString(repository)).details(details).build();
        this.publish(event, auditEntry, channels, priority);
    }

    private void auditRepositoryHookSettingsChanged(RepositoryHookSettingsChangedEvent event) throws Exception {
        String hookSettingsDetails = this.convertToJsonString(RepositoryEventListener.addProjectAndRepositoryToMap(event.getRepository(), RepositoryEventListener.getMapBuilder()).put((Object)"hook", (Object)event.getRepositoryHookKey()).put((Object)"settings", (Object)event.getSettings().asMap()).build());
        AuditEntry auditEntry = this.createHookAuditEntryBuilder((RepositoryHookEvent)event).details(hookSettingsDetails).build();
        this.publish(event, auditEntry, Sets.newHashSet((Object[])new String[]{"audit.channel.ui.repository"}), Priority.HIGH);
    }

    private void auditRepositoryModificationEvent(AbstractRepositoryModificationEvent event, Set<String> channels, Priority priority) throws Exception {
        Repository repository = event.getRepository();
        Map<String, Object> repositoryDifferences = RepositoryEventListener.diffRepositories(event.getOldValue(), event.getNewValue());
        AuditEntry auditEntry = this.createAuditEntryBuilder((StashEvent)event).repository(repository).target(RepositoryEventListener.toProjectAndRepositoryString(repository)).details(this.convertToJsonString(repositoryDifferences)).build();
        if (repositoryDifferences.size() > 0) {
            this.publish(event, auditEntry, channels, priority);
        } else {
            this.publish(event, auditEntry, Collections.<String>emptySet(), Priority.LOW);
        }
    }

    private AuditEntry.Builder createHookAuditEntryBuilder(RepositoryHookEvent event) throws IOException {
        String hookDetails = this.convertToJsonString(RepositoryEventListener.addProjectAndRepositoryToMap(event.getRepository(), RepositoryEventListener.getMapBuilder()).put((Object)"hook", (Object)event.getRepositoryHookKey()).build());
        return this.createAuditEntryBuilder((StashEvent)event).repository(event.getRepository()).target(event.getRepositoryHookKey()).details(hookDetails);
    }
}

