/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageFilter;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class UsersWithoutPermissionPageFilter
extends PageFilter<StashUser> {
    private Set<StashUser> usersWithPermission;

    public SortedMap<Integer, StashUser> apply(int limit, Page<? extends StashUser> page) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0);
        HashMap userMap = new HashMap();
        for (Map.Entry entry : page.getOrdinalIndexedValues().entrySet()) {
            userMap.put(entry.getValue(), entry.getKey());
        }
        if (this.usersWithPermission != null) {
            userMap.keySet().removeAll(this.usersWithPermission);
        } else {
            Page<? extends StashUser> usersWithPermissionPage = this.getUsersWithPermission((PageRequest)new PageRequestImpl(0, 500));
            if (usersWithPermissionPage.getIsLastPage()) {
                this.usersWithPermission = new HashSet<StashUser>();
                Iterables.addAll(this.usersWithPermission, (Iterable)usersWithPermissionPage.getValues());
                userMap.keySet().removeAll(this.usersWithPermission);
            } else {
                while (true) {
                    for (StashUser user : usersWithPermissionPage.getValues()) {
                        userMap.remove(user);
                        if (!userMap.isEmpty()) continue;
                        break;
                    }
                    if (usersWithPermissionPage.getIsLastPage() || userMap.isEmpty()) break;
                    usersWithPermissionPage = this.getUsersWithPermission(usersWithPermissionPage.getNextPageRequest());
                }
            }
        }
        TreeMap<Integer, StashUser> results = new TreeMap<Integer, StashUser>();
        for (Map.Entry entry : userMap.entrySet()) {
            results.put((Integer)entry.getValue(), (StashUser)entry.getKey());
        }
        return results;
    }

    protected abstract Page<? extends StashUser> getUsersWithPermission(PageRequest var1);
}

