/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.stash.internal.user.InternalConverter;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.user.PermittedUser;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="userUtils")
public class UserUtils {
    public static final String NAME_MATCHING_REGEX = "(\\b|^|[^\\p{L}\\p{N}])";
    private final CrowdService crowdService;

    @Autowired
    public UserUtils(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public User getBackingCrowdUser(StashUser stashUser) {
        User crowdUser = InternalConverter.convertToInternalUser(stashUser).getBackingCrowdUser();
        if (crowdUser == null) {
            crowdUser = this.crowdService.getUser(stashUser.getName());
        }
        return crowdUser;
    }

    public Page<? extends StashUser> getCrowdBackedPageOfStashUsers(Page<? extends StashUser> page) {
        for (StashUser user : page.getValues()) {
            this.loadBackingUser(user);
        }
        return page;
    }

    public Page<PermittedUser> getCrowdBackedPageOfPermittedUsers(Page<PermittedUser> page) {
        for (PermittedUser permittedUser : page.getValues()) {
            this.loadBackingUser(permittedUser.getUser());
        }
        return page;
    }

    private void loadBackingUser(StashUser user) {
        InternalStashUser stashUser = InternalConverter.convertToInternalUser(user);
        if (stashUser.getBackingCrowdUser() == null) {
            stashUser.setBackingCrowdUser(this.getBackingCrowdUser(user));
        }
    }
}

