/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageFilter;
import com.atlassian.stash.util.PredicatePageFilter;
import com.google.common.base.Predicate;
import java.util.SortedMap;
import java.util.regex.Pattern;

public class UserMatchFilter
extends PageFilter<StashUser> {
    private final PredicatePageFilter<StashUser> predicateFilter;

    public UserMatchFilter(String usernamePattern) {
        final Pattern pattern = usernamePattern == null ? null : Pattern.compile("(\\b|^|[^\\p{L}\\p{N}])" + Pattern.quote(usernamePattern), 2);
        this.predicateFilter = new PredicatePageFilter((Predicate)new Predicate<StashUser>(){

            public boolean apply(StashUser user) {
                return pattern == null || pattern.matcher(user.getName()).find() || pattern.matcher(user.getDisplayName()).find();
            }
        });
    }

    public SortedMap<Integer, StashUser> apply(int limit, Page<? extends StashUser> internalPage) {
        return this.predicateFilter.apply(limit, internalPage);
    }
}

