/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.event.user.UserAuthenticatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.RepositoryAccessedEvent;
import com.atlassian.stash.event.RepositoryDeleteRequestedEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.user.InternalConverter;
import com.atlassian.stash.internal.user.InternalRecentlyAccessedRepositoriesService;
import com.atlassian.stash.internal.user.InternalRepositoryAccess;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.RepositoryAccessDao;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.RecentlyAccessedRepositoriesService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=RecentlyAccessedRepositoriesService.class)
@Service(value="recentlyAccessedRepositoriesService")
@Transactional
public class RecentlyAccessedRepositoriesServiceImpl
implements InternalRecentlyAccessedRepositoriesService {
    private static final Logger LOG = LoggerFactory.getLogger(RecentlyAccessedRepositoriesServiceImpl.class);
    public static final int RETAIN_REPO_ACCESS_COUNT = 15;
    private final RepositoryAccessDao repositoryAccessDao;
    private final RepositoryDao respositoryDao;
    private final PermissionService permissionService;
    private final StashUserDao userDao;
    private final I18nService i18nService;
    private final StashAuthenticationContext authContext;

    @Autowired
    public RecentlyAccessedRepositoriesServiceImpl(RepositoryAccessDao repositoryAccessDao, RepositoryDao respositoryDao, PermissionService permissionService, StashUserDao userDao, I18nService i18nService, StashAuthenticationContext authContext) {
        this.repositoryAccessDao = repositoryAccessDao;
        this.respositoryDao = respositoryDao;
        this.permissionService = permissionService;
        this.userDao = userDao;
        this.i18nService = i18nService;
        this.authContext = authContext;
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public Page<Repository> getRecentlyAccessedRepositoriesForCurrentUser(PageRequest pageRequest) {
        InternalStashUser user = InternalConverter.convertToInternalUser(this.authContext.getCurrentUser());
        return this.repositoryAccessDao.findRecentlyAccessedRepositories(user, pageRequest, this.newPermPredicate(user)).transform((Function)new Function<InternalRepositoryAccess, Repository>(){

            public Repository apply(@Nullable InternalRepositoryAccess repoAccess) {
                return repoAccess.getRepository();
            }
        });
    }

    private Predicate<InternalRepositoryAccess> newPermPredicate(final InternalStashUser user) {
        return new Predicate<InternalRepositoryAccess>(){

            public boolean apply(@Nullable InternalRepositoryAccess repoAccess) {
                return RecentlyAccessedRepositoriesServiceImpl.this.permissionService.hasRepositoryPermission((StashUser)user, (Repository)repoAccess.getRepository(), Permission.REPO_READ);
            }
        };
    }

    @Override
    @Transactional
    public void onRepositoryAccessed(RepositoryAccessedEvent event) {
        if (event.getUser() != null) {
            this.repositoryAccessDao.update((Object)new InternalRepositoryAccess.Builder().user(InternalConverter.convertToInternalUser(event.getUser())).repository(InternalConverter.convertToInternalRepository(event.getRepository())).lastAccessed(event.getDate()).build());
        }
    }

    @EventListener
    @Transactional
    public void onRepositoryDeleteRequested(RepositoryDeleteRequestedEvent event) {
        this.repositoryAccessDao.deleteAllAccessesForRepository(InternalConverter.convertToInternalRepository(event.getRepository()));
    }

    @EventListener
    @Transactional
    public void onUserAuthenticated(UserAuthenticatedEvent event) {
        InternalStashUser user = this.userDao.findByName(event.getUser().getName());
        if (user != null) {
            this.repositoryAccessDao.trimToFirstPage(user, 15, this.newPermPredicate(user));
        } else {
            LOG.debug("No Stash user named {} found, unable to trim their recently accessed repositories.", (Object)event.getUser().getName());
        }
    }

    @EventListener
    @Transactional
    public void onUserDeleted(UserDeletedEvent event) {
        InternalStashUser user = this.userDao.findByName(event.getUsername());
        if (user != null) {
            this.repositoryAccessDao.deleteAllAccessesForUser(user);
        } else {
            LOG.debug("No matching Stash user for username {}, not attempting to delete their recently accessed repositories.", (Object)event.getUsername());
        }
    }

    @Component
    public static class RepoAccessListener
    implements Cloneable {
        private InternalRecentlyAccessedRepositoriesService service;

        @Autowired
        public RepoAccessListener(InternalRecentlyAccessedRepositoriesService service) {
            this.service = service;
        }

        @EventListener
        public void onRepositoryAccessed(RepositoryAccessedEvent event) {
            this.service.onRepositoryAccessed(event);
        }
    }
}

