/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.user.GrantedPermissionDao;
import com.atlassian.stash.internal.user.GroupPermissionSearchCriteria;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.internal.user.UserPermissionSearchCriteria;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="permissionService")
@AvailableToPlugins(value=PermissionService.class)
@Transactional(readOnly=true)
public class PermissionServiceImpl
implements PermissionService {
    public static final int GROUP_PAGESIZE = 1000;
    public static final int USER_PAGESIZE = 2000;
    private static final Logger LOG = LoggerFactory.getLogger(PermissionServiceImpl.class);
    private static final Predicate<Permission> GRANTABLE_TO_ANONYMOUS = new Predicate<Permission>(){

        public boolean apply(Permission permission) {
            return permission.isGrantableToAnonymous();
        }
    };
    public static final String GROUP_PERMISSION_SEARCH = "Group Permission Search";
    public static final int USER_GROUP_PAGE_LIMIT = 500;
    private final StashAuthenticationContext authenticationContext;
    private final GrantedPermissionDao grantedPermissionDao;
    private final RepositoryDao repositoryDao;
    private final UserService userService;

    @Autowired
    public PermissionServiceImpl(GrantedPermissionDao grantedPermissionDao, UserService userService, StashAuthenticationContext authenticationContext, RepositoryDao repositoryDao) {
        this.authenticationContext = authenticationContext;
        this.grantedPermissionDao = grantedPermissionDao;
        this.repositoryDao = repositoryDao;
        this.userService = userService;
    }

    public boolean hasGlobalPermission(@Nullable String userName, @Nonnull Permission permission) {
        StashUser user = userName == null ? null : this.userService.getUser(userName);
        return this.hasGlobalPermission(user, permission);
    }

    public boolean hasGlobalPermission(@Nullable StashUser user, @Nonnull Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.hasPermission(user, null, permission);
    }

    public boolean hasGlobalPermission(@Nonnull Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.hasGlobalPermission(this.authenticationContext.getCurrentUser(), permission);
    }

    public boolean hasAnyUserPermission(@Nonnull StashUser user, @Nonnull Permission permission) {
        return this.hasPermission(user, -1, permission);
    }

    public boolean hasAnyUserPermission(@Nonnull Permission permission) {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        return currentUser != null && this.hasAnyUserPermission(currentUser, permission);
    }

    public boolean hasProjectPermission(@Nullable StashUser user, @Nonnull Project project, @Nonnull Permission permission) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        return this.hasPermission(user, project.getId(), permission);
    }

    public boolean hasProjectPermission(@Nonnull Project project, @Nonnull Permission permission) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        return this.hasProjectPermission(this.authenticationContext.getCurrentUser(), project, permission);
    }

    public boolean hasProjectPermission(@Nonnull Integer projectId, @Nonnull Permission permission) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        return this.hasPermission(this.authenticationContext.getCurrentUser(), projectId, permission);
    }

    public boolean hasProjectPermission(@Nullable StashUser user, @Nonnull Integer projectId, @Nonnull Permission requestedPermission) {
        Preconditions.checkArgument((!requestedPermission.isGlobal() ? 1 : 0) != 0);
        return this.hasPermission(user, projectId, requestedPermission);
    }

    private boolean hasPermission(StashUser user, Integer projectId, Permission permission) {
        Set inheritingPermissions = permission.getInheritingPermissions();
        if (LOG.isTraceEnabled()) {
            LOG.trace("user = " + user);
            LOG.trace("projectId = " + projectId);
            LOG.trace("requested permission = " + permission);
        }
        if (user instanceof StashUserAuthenticationToken) {
            StashUserAuthenticationToken token = (StashUserAuthenticationToken)user;
            for (Permission runWithPermission : token.getRunWithPermissions()) {
                if (!inheritingPermissions.contains(runWithPermission)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("permission granted by elevated permissions (from %s)", StashAuthenticationContext.class.getSimpleName()));
                }
                return true;
            }
            if (token.getPrincipal() == null) {
                return false;
            }
        }
        return user != null && (this.hasDirectUserPermission(user, projectId, permission) || this.hasPermissionsThroughGroup(user, projectId, permission, Collections.<String>emptySet()));
    }

    public boolean hasDirectGlobalUserPermission(Permission permission) {
        return this.hasDirectUserPermission(this.authenticationContext.getCurrentUser(), null, permission);
    }

    public boolean hasDirectProjectUserPermission(Project project, Permission permission) {
        return this.hasDirectUserPermission(this.authenticationContext.getCurrentUser(), project.getId(), permission);
    }

    private boolean hasDirectUserPermission(StashUser user, Integer projectId, Permission permission) {
        boolean granted;
        Integer userId = user.getId();
        if (userId == null) {
            return false;
        }
        UserPermissionSearchCriteria criteria = new UserPermissionSearchCriteria();
        criteria.setPermission(permission);
        criteria.setUser(userId.intValue());
        if (projectId != null) {
            criteria.setProjectId(projectId.intValue());
        }
        if (granted = this.grantedPermissionDao.isGrantedToUser(criteria)) {
            LOG.trace("{}: {}, or an inheriting permission, has been explicit granted", (Object)user.getName(), (Object)permission);
        } else {
            LOG.trace("{}: {} has not been explicitly granted", (Object)user.getName(), (Object)permission);
        }
        return granted;
    }

    public boolean hasGlobalGroupPermission(Permission permission, String group) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        GroupPermissionSearchCriteria criteria = new GroupPermissionSearchCriteria();
        criteria.setGroups((Set)ImmutableSet.of((Object)group));
        criteria.setPermission(permission);
        return this.grantedPermissionDao.isGrantedToGroup(criteria);
    }

    public Page<StashUser> getGrantedUsers(Permission permission, PageRequest request) {
        UserPermissionSearchCriteria criteria = new UserPermissionSearchCriteria();
        criteria.setPermission(permission);
        return this.grantedPermissionDao.searchUsers(criteria, request);
    }

    public Page<String> getGrantedGroups(Permission permission, PageRequest request) {
        GroupPermissionSearchCriteria criteria = new GroupPermissionSearchCriteria();
        criteria.setPermission(permission);
        return this.grantedPermissionDao.searchGroups(criteria, request);
    }

    public boolean hasGlobalPermissionThroughGroupMembership(Permission permission, Set<String> excludedGroups) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.hasPermissionsThroughGroup(this.authenticationContext.getCurrentUser(), null, permission, excludedGroups);
    }

    public boolean hasProjectPermissionThroughGroupMembership(Project project, Permission permission, Set<String> excludedGroups) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        return this.hasPermissionsThroughGroup(this.authenticationContext.getCurrentUser(), project.getId(), permission, excludedGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPermissionsThroughGroup(StashUser user, Integer projectId, Permission permission, Set<String> excludedGroups) {
        UtilTimerStack.push((String)GROUP_PERMISSION_SEARCH);
        try {
            GroupPermissionSearchCriteria criteria = new GroupPermissionSearchCriteria();
            criteria.setPermission(permission);
            if (projectId != null) {
                criteria.setProjectId(projectId.intValue());
            }
            PageRequestImpl pageRequest = new PageRequestImpl(0, 500);
            Page page = this.userService.getGroupsForUser(user.getName(), (PageRequest)pageRequest);
            while (true) {
                HashSet groups = Sets.newHashSet((Iterable)page.getValues());
                Iterables.removeAll((Iterable)groups, excludedGroups);
                if (groups.isEmpty()) {
                    LOG.trace("All groups on the page have been excluded");
                } else {
                    criteria.setGroups((Set)groups);
                    LOG.trace("Testing for permission against {} groups", (Object)groups.size());
                    boolean granted = this.grantedPermissionDao.isGrantedToGroup(criteria);
                    if (granted) {
                        LOG.trace("{}: Permission {} granted by group membership", (Object)user.getName(), (Object)permission);
                        boolean bl = true;
                        return bl;
                    }
                }
                if (page.getIsLastPage()) break;
                LOG.trace("{}: Loading next page of groups", (Object)user.getName());
                page = this.userService.getGroupsForUser(user.getName(), page.getNextPageRequest());
            }
            LOG.trace("{}: All group memberships have been exhausted", (Object)user.getName());
            LOG.trace("permission not granted by any group membership");
            boolean bl = false;
            return bl;
        }
        finally {
            UtilTimerStack.pop((String)GROUP_PERMISSION_SEARCH);
        }
    }

    public boolean hasRepositoryPermission(@Nullable StashUser user, @Nonnull Repository repository, @Nonnull Permission permission) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        return this.hasPermission(user, repository.getProject().getId(), permission);
    }

    public boolean hasRepositoryPermission(@Nullable StashUser user, @Nonnull Integer repoId, @Nonnull Permission permission) {
        Repository repository = (Repository)this.repositoryDao.getById((Object)repoId);
        return this.hasRepositoryPermission(user, repository, permission);
    }

    public boolean hasRepositoryPermission(@Nonnull Repository repository, @Nonnull Permission permission) {
        return this.hasRepositoryPermission(this.authenticationContext.getCurrentUser(), repository, permission);
    }

    public boolean hasRepositoryPermission(@Nonnull Integer repositoryId, @Nonnull Permission permission) {
        return this.hasRepositoryPermission(this.authenticationContext.getCurrentUser(), repositoryId, permission);
    }

    public Set<String> getUsersWithPermission(Permission permission) {
        Page<String> groups;
        Page<StashUser> users;
        HashSet<String> usersWithPermission = new HashSet<String>();
        PageRequestImpl request = new PageRequestImpl(0, 2000);
        do {
            users = this.getGrantedUsers(permission, (PageRequest)request);
            for (StashUser user : users.getValues()) {
                usersWithPermission.add(IdentifierUtils.toLowerCase((String)user.getName()));
            }
        } while ((request = users.getNextPageRequest()) != null);
        request = new PageRequestImpl(0, 1000);
        do {
            groups = this.getGrantedGroups(permission, (PageRequest)request);
            for (String group : groups.getValues()) {
                Page users2 = this.userService.getUsersInGroup(group, (PageRequest)request);
                for (String username : users2.getValues()) {
                    usersWithPermission.add(IdentifierUtils.toLowerCase((String)username));
                }
            }
        } while ((request = groups.getNextPageRequest()) != null);
        return usersWithPermission;
    }

    public int getCountOfUsersWithPermission(Permission permission) {
        return this.getUsersWithPermission(permission).size();
    }

    public Permission getHighestGlobalPermission(@Nullable StashUser user) {
        if (user == null) {
            return null;
        }
        List<Permission> globalPermissions = this.getOrderedGlobalPermissions();
        for (Permission globalPermission : globalPermissions) {
            if (!this.hasGlobalPermission(user, globalPermission)) continue;
            return globalPermission;
        }
        return null;
    }

    public Permission getHighestGlobalPermission(@Nullable String userName) {
        StashUser user = userName != null ? this.userService.getUser(userName) : null;
        return user != null ? this.getHighestGlobalPermission(user) : null;
    }

    public Permission getHighestGlobalGroupPermission(@Nullable String groupName) {
        if (groupName == null) {
            return null;
        }
        List<Permission> globalPermissions = this.getOrderedGlobalPermissions();
        for (Permission globalPermission : globalPermissions) {
            if (!this.hasGlobalGroupPermission(globalPermission, groupName)) continue;
            return globalPermission;
        }
        return null;
    }

    private List<Permission> getOrderedGlobalPermissions() {
        ArrayList globalPermissions = Lists.newArrayList((Iterable)Permission.getGlobalPermissions());
        Collections.sort(globalPermissions, new Comparator<Permission>(){

            @Override
            public int compare(Permission o1, Permission o2) {
                return o1 == o2 ? 0 : (o1.getWeight() < o2.getWeight() ? 1 : (o1.getWeight() > o2.getWeight() ? -1 : 0));
            }
        });
        return globalPermissions;
    }
}

