/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.permission.PermissionGrantedEvent;
import com.atlassian.stash.event.permission.PermissionRevokedEvent;
import com.atlassian.stash.exception.ForbiddenException;
import com.atlassian.stash.exception.IntegrityException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.user.CrowdUserWrapper;
import com.atlassian.stash.internal.user.GrantedPermissionDao;
import com.atlassian.stash.internal.user.GroupMatchFilter;
import com.atlassian.stash.internal.user.GroupPermissionSearchCriteria;
import com.atlassian.stash.internal.user.GroupsWithoutPermissionFilter;
import com.atlassian.stash.internal.user.InternalConverter;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.PermissionFilterMode;
import com.atlassian.stash.internal.user.UserMatchFilter;
import com.atlassian.stash.internal.user.UserPermissionSearchCriteria;
import com.atlassian.stash.internal.user.UserUtils;
import com.atlassian.stash.internal.user.UsersWithoutPermissionPageFilter;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.PermittedGroup;
import com.atlassian.stash.user.PermittedUser;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.FilteredPageProvider;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageFilter;
import com.atlassian.stash.util.PageImpl;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="permissionAdminService")
@AvailableToPlugins(value=PermissionAdminService.class)
@Transactional(readOnly=true)
public class PermissionAdminServiceImpl
implements PermissionAdminService {
    public static final Function<String, String> TO_LOWERCASE_FN = new Function<String, String>(){

        public String apply(@Nullable String groupName) {
            return IdentifierUtils.toLowerCase((String)groupName);
        }
    };
    public static final int INTERNAL_PAGE_LIMIT = 500;
    private final CrowdService crowdService;
    private final EventPublisher eventPublisher;
    private final GrantedPermissionDao grantedPermissionDao;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final int maxUsers;
    private final int maxGroups;
    private final PermissionService permissionService;
    private final StashAuthenticationContext authenticationContext;
    private final UserService userService;
    private final UserUtils userUtils;

    @Autowired
    public PermissionAdminServiceImpl(UserService userService, GrantedPermissionDao grantedPermissionDao, StashAuthenticationContext authenticationContext, PermissionService permissionService, I18nService i18nService, CrowdService crowdService, UserUtils userUtils, LicenseService licenseService, EventPublisher eventPublisher, @Value(value="${page.max.users}") int maxUsers, @Value(value="${page.max.groups}") int maxGroups) {
        this.userService = userService;
        this.grantedPermissionDao = grantedPermissionDao;
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
        this.i18nService = i18nService;
        this.crowdService = crowdService;
        this.licenseService = licenseService;
        this.eventPublisher = eventPublisher;
        this.maxUsers = maxUsers;
        this.maxGroups = maxGroups;
        this.userUtils = userUtils;
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<PermittedUser> getUsersWithGlobalPermission(@Nonnull PageRequest pageRequest) {
        UserPermissionSearchCriteria criteria = new UserPermissionSearchCriteria();
        criteria.setFilterMode(PermissionFilterMode.ONLY_GLOBAL);
        criteria.setName(pageRequest.getFilter());
        return this.userUtils.getCrowdBackedPageOfPermittedUsers((Page<PermittedUser>)this.grantedPermissionDao.getPermittedUsers(criteria, pageRequest));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<? extends StashUser> getUsersWithoutGlobalPermission(@Nonnull PageRequest request) {
        final UserPermissionSearchCriteria criteria = new UserPermissionSearchCriteria();
        criteria.setFilterMode(PermissionFilterMode.ONLY_GLOBAL);
        UsersWithoutPermissionPageFilter usersWithoutPermissionFilter = new UsersWithoutPermissionPageFilter(){

            @Override
            protected Page<? extends StashUser> getUsersWithPermission(PageRequest request) {
                return PermissionAdminServiceImpl.this.grantedPermissionDao.searchUsers(criteria, request);
            }
        };
        return this.getUsersWithoutPermission(request.getFilter(), usersWithoutPermissionFilter, request);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<PermittedGroup> getGroupsWithGlobalPermission(@Nonnull PageRequest pageRequest) {
        GroupPermissionSearchCriteria criteria = new GroupPermissionSearchCriteria();
        criteria.setFilterMode(PermissionFilterMode.ONLY_GLOBAL);
        criteria.setName(pageRequest.getFilter());
        return this.grantedPermissionDao.getPermittedGroups(criteria, pageRequest);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<String> getGroupsWithoutGlobalPermission(@Nonnull PageRequest pageRequest) {
        final GroupPermissionSearchCriteria criteria = new GroupPermissionSearchCriteria();
        criteria.setFilterMode(PermissionFilterMode.ONLY_GLOBAL);
        GroupsWithoutPermissionFilter groupsWithoutPermissionFilter = new GroupsWithoutPermissionFilter(){

            @Override
            protected Page<String> getGroupsWithPermission(PageRequest pageRequest) {
                return PermissionAdminServiceImpl.this.grantedPermissionDao.searchGroups(criteria, pageRequest);
            }
        };
        return this.getGroupsWithoutPermission(pageRequest.getFilter(), groupsWithoutPermissionFilter, pageRequest);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<PermittedUser> getUsersWithProjectPermission(@Nonnull Project project, @Nonnull PageRequest pageRequest) {
        UserPermissionSearchCriteria criteria = new UserPermissionSearchCriteria();
        criteria.setFilterMode(PermissionFilterMode.ONLY_RESOURCE);
        criteria.setProjectId(project.getId().intValue());
        criteria.setName(pageRequest.getFilter());
        return this.userUtils.getCrowdBackedPageOfPermittedUsers((Page<PermittedUser>)this.grantedPermissionDao.getPermittedUsers(criteria, pageRequest));
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<? extends StashUser> getUsersWithoutProjectPermission(@Nonnull Project project, @Nonnull PageRequest pageRequest) {
        final UserPermissionSearchCriteria criteria = new UserPermissionSearchCriteria();
        criteria.setFilterMode(PermissionFilterMode.ONLY_RESOURCE);
        criteria.setProjectId(project.getId().intValue());
        UsersWithoutPermissionPageFilter usersWithoutPermissionFilter = new UsersWithoutPermissionPageFilter(){

            @Override
            protected Page<? extends StashUser> getUsersWithPermission(PageRequest request) {
                return PermissionAdminServiceImpl.this.grantedPermissionDao.searchUsers(criteria, request);
            }
        };
        return this.getUsersWithoutPermission(pageRequest.getFilter(), usersWithoutPermissionFilter, pageRequest);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<PermittedGroup> getGroupsWithProjectPermission(@Nonnull Project project, @Nonnull PageRequest pageRequest) {
        GroupPermissionSearchCriteria criteria = new GroupPermissionSearchCriteria();
        criteria.setFilterMode(PermissionFilterMode.ONLY_RESOURCE);
        criteria.setProjectId(project.getId().intValue());
        criteria.setName(pageRequest.getFilter());
        return this.grantedPermissionDao.getPermittedGroups(criteria, pageRequest);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<String> getGroupsWithoutProjectPermission(@Nonnull Project project, @Nonnull PageRequest pageRequest) {
        final GroupPermissionSearchCriteria criteria = new GroupPermissionSearchCriteria();
        criteria.setFilterMode(PermissionFilterMode.ONLY_RESOURCE);
        criteria.setProjectId(((Project)Preconditions.checkNotNull((Object)project)).getId().intValue());
        GroupsWithoutPermissionFilter groupsWithoutPermissionFilter = new GroupsWithoutPermissionFilter(){

            @Override
            protected Page<String> getGroupsWithPermission(PageRequest pageRequest) {
                return PermissionAdminServiceImpl.this.grantedPermissionDao.searchGroups(criteria, pageRequest);
            }
        };
        return this.getGroupsWithoutPermission(pageRequest.getFilter(), groupsWithoutPermissionFilter, pageRequest);
    }

    private Page<? extends StashUser> getUsersWithoutPermission(String usernamePattern, UsersWithoutPermissionPageFilter pageFilter, PageRequest request) {
        PageProvider<StashUser> userProvider = this.createUserProvider(usernamePattern);
        UserMatchFilter userMatchFilter = new UserMatchFilter(usernamePattern);
        FilteredPageProvider filteredPageProvider = new FilteredPageProvider(userProvider, (PageFilter)pageFilter);
        filteredPageProvider = new FilteredPageProvider((PageProvider)filteredPageProvider, (PageFilter)userMatchFilter);
        PageRequest pageRequest = request.buildRestrictedPageRequest(this.maxUsers);
        return filteredPageProvider.get(pageRequest);
    }

    private Page<String> getGroupsWithoutPermission(final String groupnamePattern, PageFilter<String> groupsWithoutPermissionFilter, PageRequest request) {
        PageProvider<String> groupsProvider = new PageProvider<String>(){

            public Page<String> get(PageRequest request) {
                return PermissionAdminServiceImpl.this.userService.findGroupsByContainedText(groupnamePattern, request);
            }
        };
        GroupMatchFilter groupMatchFilter = new GroupMatchFilter(groupnamePattern);
        FilteredPageProvider filteredProvider = new FilteredPageProvider((PageProvider)groupsProvider, groupsWithoutPermissionFilter);
        filteredProvider = new FilteredPageProvider((PageProvider)filteredProvider, (PageFilter)groupMatchFilter);
        PageRequest pageRequest = request.buildRestrictedPageRequest(this.maxGroups);
        return filteredProvider.get(pageRequest).transform(TO_LOWERCASE_FN);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGlobalPermissions(@Nonnull String group) {
        Permission mine = this.permissionService.getHighestGlobalPermission(this.authenticationContext.getCurrentUser());
        Permission theirs = this.permissionService.getHighestGlobalGroupPermission(group);
        if (theirs != null && theirs.getWeight() > mine.getWeight()) {
            throw new IntegrityException(this.i18nService.getKeyedText("stash.service.permissionadmin.revoke.insufficient.permission", "You have insufficient permission to change {0}''s permissions", new Object[]{group}));
        }
        for (Permission permission : Permission.getGlobalPermissions()) {
            if (!this.grantedPermissionDao.hasPermissionEntry(permission, null, group, null)) continue;
            this.revokeGlobalPermission(permission, group);
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGlobalPermissions(@Nonnull StashUser user) {
        Permission mine = this.permissionService.getHighestGlobalPermission(this.authenticationContext.getCurrentUser());
        Permission theirs = this.permissionService.getHighestGlobalPermission(user);
        if (theirs != null && theirs.getWeight() > mine.getWeight()) {
            throw new IntegrityException(this.i18nService.getKeyedText("stash.service.permissionadmin.revoke.insufficient.permission", "You have insufficient permission to change {0}''s permissions", new Object[]{user.getDisplayName()}));
        }
        for (Permission permission : Permission.getGlobalPermissions()) {
            if (!this.grantedPermissionDao.hasPermissionEntry(permission, null, null, user)) continue;
            this.revokeGlobalPermission(permission, user);
        }
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermissions(@Nonnull Project project, @Nonnull String group) {
        for (Permission permission : Permission.getResourcePermissions()) {
            if (!permission.isProjectRelated()) continue;
            this.revokeProjectPermission(permission, project, group);
        }
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermissions(@Nonnull Project project, @Nonnull StashUser user) {
        for (Permission permission : Permission.getResourcePermissions()) {
            if (!permission.isProjectRelated()) continue;
            this.revokeProjectPermission(permission, project, user);
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN') and hasGlobalPermission(#permission)")
    public void setGlobalPermission(@Nonnull Permission permission, @Nonnull String group) {
        this.revokeAllGlobalPermissions(group);
        this.grantGlobalPermission(permission, group);
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void setProjectPermission(@Nonnull Project project, @Nonnull Permission permission, @Nonnull String group) {
        this.revokeAllProjectPermissions(project, group);
        this.setProjectPermission(permission, project, group);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN') and hasGlobalPermission(#permission)")
    public void setGlobalPermission(@Nonnull Permission permission, @Nonnull StashUser user) {
        this.revokeAllGlobalPermissions(user);
        this.grantGlobalPermission(permission, user);
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void setProjectPermission(@Nonnull Project project, @Nonnull Permission permission, @Nonnull StashUser user) {
        this.revokeAllProjectPermissions(project, user);
        this.grantProjectPermission(permission, project, user);
    }

    private PageProvider<StashUser> createUserProvider(String usernamePattern) {
        NullRestriction searchRestriction = usernamePattern == null ? NullRestrictionImpl.INSTANCE : Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)usernamePattern), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernamePattern)});
        return new PageProvider<StashUser>((SearchRestriction)searchRestriction){
            final /* synthetic */ SearchRestriction val$searchRestriction;
            {
                this.val$searchRestriction = searchRestriction;
            }

            public Page<StashUser> get(PageRequest request) {
                EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)this.val$searchRestriction, (int)request.getStart(), (int)(request.getLimit() + 1));
                Iterable users = PermissionAdminServiceImpl.this.crowdService.search((Query)query);
                int size = Iterables.size((Iterable)users);
                int returnedSize = Math.min(size, request.getLimit());
                Iterable result = Iterables.transform((Iterable)Iterables.limit((Iterable)users, (int)returnedSize), (Function)new Function<User, StashUser>(){

                    public StashUser apply(User crowdUser) {
                        return new CrowdUserWrapper(crowdUser);
                    }
                });
                return new PageImpl(request, returnedSize, result, size <= request.getLimit());
            }
        };
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN') and hasGlobalPermission(#permission)")
    public boolean hasAllGlobalPermission(@Nonnull Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.grantedPermissionDao.hasPermissionEntry(permission, null, null, null);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public boolean hasAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)project);
        return this.grantedPermissionDao.hasPermissionEntry(permission, project, null, null);
    }

    private void grantProjectPermission(@Nonnull Permission permission, @Nonnull Project project, @Nonnull StashUser user) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)user);
        InternalGrantedPermission perm = new InternalGrantedPermission(permission, InternalConverter.convertToInternalProject(project), null, InternalConverter.convertToInternalUser(user));
        this.grantPermission(perm);
    }

    private void setProjectPermission(@Nonnull Permission permission, @Nonnull Project project, @Nonnull String group) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)group);
        InternalGrantedPermission perm = new InternalGrantedPermission(permission, InternalConverter.convertToInternalProject(project), group, null);
        this.grantPermission(perm);
    }

    private void grantGlobalPermission(@Nonnull Permission permission, @Nonnull StashUser user) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        Preconditions.checkNotNull((Object)user);
        this.licenseService.validateCanLicenseUser(user, permission);
        this.grantPermission(new InternalGrantedPermission(permission, null, null, InternalConverter.convertToInternalUser(user)));
    }

    private void grantGlobalPermission(@Nonnull Permission permission, @Nonnull String group) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        Preconditions.checkNotNull((Object)group);
        this.licenseService.validateCanLicenseGroup(group, permission);
        this.grantPermission(new InternalGrantedPermission(permission, null, group, null));
    }

    private void grantPermission(InternalGrantedPermission perm) {
        if (!this.grantedPermissionDao.hasPermissionEntry(perm)) {
            this.grantedPermissionDao.create((Object)perm);
            PermissionGrantedEvent event = new PermissionGrantedEvent((Object)this, perm.getPermission(), (Project)perm.getProject(), perm.getGroup(), (StashUser)perm.getUser());
            this.eventPublisher.publish((Object)event);
        }
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void grantAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        InternalGrantedPermission perm = new InternalGrantedPermission(permission, InternalConverter.convertToInternalProject(project), null, null);
        this.grantPermission(perm);
    }

    private void revokeProjectPermission(@Nonnull Permission permission, @Nonnull Project project, @Nonnull StashUser user) {
        boolean revokeAllowed;
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        boolean bl = revokeAllowed = !user.equals(this.authenticationContext.getCurrentUser());
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedProjectPermission(permission, project);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasProjectPermissionThroughGroupMembership(project, permission, Collections.emptySet());
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cantrevokeownprojectpermission", "You cannot revoke permission on {0} as it would downgrade your own permissions.", new Object[]{project.getName()});
            throw new IntegrityException(message);
        }
        this.revokePermission(permission, project, user, null);
        this.revokePermission(permission, project, user, null);
    }

    private void revokeProjectPermission(@Nonnull Permission permission, @Nonnull Project project, @Nonnull String group) {
        boolean revokeAllowed;
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        boolean bl = revokeAllowed = currentUser == null || !this.userService.isUserMemberOfGroup(currentUser, group);
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedProjectPermission(permission, project);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasDirectProjectUserPermission(project, permission);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasProjectPermissionThroughGroupMembership(project, permission, Collections.singleton(group));
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cantrevokegroupprojectpermission", "You cannot revoke the permission of group {1} on {0} as it would downgrade your own permissions.", new Object[]{project.getName(), group});
            throw new IntegrityException(message);
        }
        this.revokePermission(permission, project, null, group);
    }

    private boolean currentUserHasImpliedProjectPermission(Permission permission, Project project) {
        Permission higherPermission;
        Set implyingPermissions = permission.getImplyingPermissions();
        boolean hasImpliedProjectPermission = false;
        Iterator i$ = implyingPermissions.iterator();
        while (i$.hasNext() && !(hasImpliedProjectPermission = (higherPermission = (Permission)i$.next()).isGlobal() ? this.permissionService.hasGlobalPermission(higherPermission) : this.permissionService.hasProjectPermission(project, higherPermission))) {
        }
        return hasImpliedProjectPermission;
    }

    private void revokeGlobalPermission(@Nonnull Permission permission, @Nonnull StashUser user) {
        boolean revokeAllowed;
        Preconditions.checkArgument((boolean)permission.isGlobal());
        boolean bl = revokeAllowed = !user.equals(this.authenticationContext.getCurrentUser());
        if (!revokeAllowed) {
            Permission higherPermission;
            Set implyingPermissions = permission.getImplyingPermissions();
            Iterator i$ = implyingPermissions.iterator();
            while (i$.hasNext() && !(revokeAllowed = this.permissionService.hasGlobalPermission(higherPermission = (Permission)i$.next()))) {
            }
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasGlobalPermissionThroughGroupMembership(permission, Collections.emptySet());
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cantrevokeownpermission", "You cannot revoke this permission as it would downgrade your own permissions.", new Object[0]);
            throw new IntegrityException(message);
        }
        this.revokePermission(permission, null, user, null);
    }

    private void revokePermission(Permission permission, Project project, StashUser user, String group) {
        if (this.grantedPermissionDao.hasPermissionEntry(permission, project, group, user)) {
            Integer projectId = project == null ? null : project.getId();
            Integer userId = user == null ? null : user.getId();
            String groupName = group == null ? null : group;
            this.grantedPermissionDao.deleteGrantedPermissions(permission, projectId, userId, groupName);
            PermissionRevokedEvent event = new PermissionRevokedEvent((Object)this, permission, project, group, user);
            this.eventPublisher.publish((Object)event);
        }
    }

    private void revokeGlobalPermission(@Nonnull Permission permission, @Nonnull String group) {
        boolean revokeAllowed;
        Preconditions.checkArgument((boolean)permission.isGlobal());
        InternalStashUser currentUser = InternalConverter.convertToInternalUser(this.authenticationContext.getCurrentUser());
        boolean bl = revokeAllowed = currentUser == null || !this.userService.isUserMemberOfGroup((StashUser)currentUser, group);
        if (!revokeAllowed) {
            Permission higherPermission;
            Set implyingPermissions = permission.getImplyingPermissions();
            Iterator i$ = implyingPermissions.iterator();
            while (i$.hasNext() && !(revokeAllowed = this.permissionService.hasGlobalPermission(higherPermission = (Permission)i$.next()))) {
            }
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasDirectGlobalUserPermission(permission);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasGlobalPermissionThroughGroupMembership(permission, Collections.singleton(group));
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cantrevokegrouppermission", "You cannot revoke the permission of group {0} as it would downgrade your own permissions.", new Object[]{group});
            throw new IntegrityException(message);
        }
        this.revokePermission(permission, null, null, group);
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        this.revokePermission(permission, project, null, null);
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermissions(@Nonnull Project project) {
        this.grantedPermissionDao.deleteAllProjectPermissions(project.getId());
    }

    @Transactional
    @PreAuthorize(value="not isCurrentUser(#username) and (hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN')))")
    public void revokeAllUserPermissions(@Nonnull String username) {
        StashUser user = this.userService.getUser(username, true);
        if (user != null) {
            this.grantedPermissionDao.deleteAllUserPermissions(user.getId().intValue());
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGroupPermissions(@Nonnull String name) {
        this.canRemovePermissionsFromGroup(name);
        this.grantedPermissionDao.deleteAllGroupPermissions(name);
    }

    private void canRemovePermissionsFromGroup(String name) {
        try {
            this.canDeleteGroup(name);
        }
        catch (IntegrityException e) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotremovepermissionsgroup", "You cannot remove the permissions of this group as it would remove your own privileges.", new Object[0]);
            throw new IntegrityException(message);
        }
        catch (ForbiddenException e) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotdeletegroup", "You cannot remove the permissions of the group {0} as it has System Administrator privileges, and you are not a System Administrator.", new Object[]{name});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canRemoveUserFromGroup(@Nonnull String username, @Nonnull String group) {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && IdentifierUtils.equalsInLowerCase((String)currentUser.getName(), (String)username)) {
            if (!this.userService.isUserMemberOfGroup(currentUser, group)) {
                return;
            }
            if (!this.canRemoveCurrentUserFromGroup(group)) {
                KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotremoveself", "You cannot remove yourself from this group as it would remove your own privilege.", new Object[0]);
                throw new IntegrityException(message);
            }
        } else if (this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotremoveuser", "You cannot remove {0} from the group {1} as it has System Administrator privileges, and you are not a System Administrator.", new Object[]{username, group});
            throw new ForbiddenException(message);
        }
    }

    private boolean canRemoveCurrentUserFromGroup(String group) {
        return !(this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group) ? !this.permissionService.hasDirectGlobalUserPermission(Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermissionThroughGroupMembership(Permission.SYS_ADMIN, Collections.singleton(group)) : this.permissionService.hasGlobalGroupPermission(Permission.ADMIN, group) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && !this.permissionService.hasDirectGlobalUserPermission(Permission.ADMIN) && !this.permissionService.hasGlobalPermissionThroughGroupMembership(Permission.ADMIN, Collections.singleton(group)));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canAddUserToGroup(@Nonnull String group) {
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group)) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotaddusertogroup", "You cannot add a user to the group {0} as it has System Administrator privileges, and you are not a System Administrator.", new Object[]{group});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canDeleteGroup(@Nonnull String group) {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && this.userService.isUserMemberOfGroup(currentUser, group)) {
            if (!this.canRemoveCurrentUserFromGroup(group)) {
                KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotremovegroup", "You cannot remove this group as it would remove your own privileges.", new Object[0]);
                throw new IntegrityException(message);
            }
        } else if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group)) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotdeletegroup", "You cannot remove the group {0} as it has System Administrator privileges, and you are not a System Administrator.", new Object[]{group});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canDeleteUser(@Nonnull String username) {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && IdentifierUtils.equalsInLowerCase((String)currentUser.getName(), (String)username)) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.selfdelete", "You cannot delete yourself.", new Object[0]);
            throw new IntegrityException(message);
        }
        StashUser user = this.userService.getUser(username);
        if (user == null) {
            return;
        }
        if (this.permissionService.hasGlobalPermission(user, Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotdeleteuser", "You cannot delete the user {0} as they have System Administrator privileges, and you are not a System Administrator.", new Object[]{user.getName()});
            throw new ForbiddenException(message);
        }
    }
}

