/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageFilter;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class GroupsWithoutPermissionFilter
extends PageFilter<String> {
    public static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return IdentifierUtils.compareToInLowerCase((String)s1, (String)s2);
        }
    };
    private Set<String> groupsWithPermission;

    public SortedMap<Integer, String> apply(int limit, Page<? extends String> page) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0);
        TreeMap groupsWithPermissionMap = new TreeMap(CASE_INSENSITIVE_COMPARATOR);
        for (Map.Entry entry : page.getOrdinalIndexedValues().entrySet()) {
            groupsWithPermissionMap.put((String)entry.getValue(), entry.getKey());
        }
        if (this.groupsWithPermission != null) {
            groupsWithPermissionMap.keySet().removeAll(this.groupsWithPermission);
        } else {
            Page<String> groupsWithPermPage = this.getGroupsWithPermission((PageRequest)new PageRequestImpl(0, 500));
            if (groupsWithPermPage.getIsLastPage()) {
                this.groupsWithPermission = new TreeSet<String>(CASE_INSENSITIVE_COMPARATOR);
                Iterables.addAll(this.groupsWithPermission, (Iterable)groupsWithPermPage.getValues());
                groupsWithPermissionMap.keySet().removeAll(this.groupsWithPermission);
            } else {
                while (true) {
                    for (String group : groupsWithPermPage.getValues()) {
                        groupsWithPermissionMap.remove(group);
                        if (!groupsWithPermissionMap.isEmpty()) continue;
                        break;
                    }
                    if (groupsWithPermissionMap.isEmpty() || groupsWithPermPage.getIsLastPage()) break;
                    groupsWithPermPage = this.getGroupsWithPermission(groupsWithPermPage.getNextPageRequest());
                }
            }
        }
        TreeMap<Integer, String> results = new TreeMap<Integer, String>();
        for (Map.Entry entry : groupsWithPermissionMap.entrySet()) {
            results.put((Integer)entry.getValue(), (String)entry.getKey());
        }
        return results;
    }

    protected abstract Page<String> getGroupsWithPermission(PageRequest var1);
}

