/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.AvatarSource;
import com.atlassian.stash.user.AvatarRequest;
import com.atlassian.stash.user.Person;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.encoding.MessageDigestPasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

@Component(value="gravatarAvatarSource")
public class GravatarAvatarSource
implements AvatarSource {
    public static final String HTTP_GRAVATAR_URL_FORMAT = "http://www.gravatar.com/avatar/%1$s.jpg?s=%2$d&d=%3$s";
    public static final String HTTPS_GRAVATAR_URL_FORMAT = "https://secure.gravatar.com/avatar/%1$s.jpg?s=%2$d&d=%3$s";
    private static final Logger log = LoggerFactory.getLogger(GravatarAvatarSource.class);
    private final AvatarSource fallbackAvatarSource;
    private final MessageDigestPasswordEncoder md5;

    @Autowired
    public GravatarAvatarSource(@Qualifier(value="webResourceAvatarSource") AvatarSource fallbackAvatarSource, @Qualifier(value="md5Encoder") MessageDigestPasswordEncoder md5) {
        this.fallbackAvatarSource = fallbackAvatarSource;
        this.md5 = md5;
    }

    @Nonnull
    public String getAvatarUrl(@Nonnull Person person, @Nonnull AvatarRequest request) {
        Preconditions.checkNotNull((Object)person);
        String avatarUrl = this.fallbackAvatarSource.getAvatarUrl(person, request);
        String emailAddress = person.getEmailAddress();
        if (StringUtils.isNotBlank((String)emailAddress)) {
            avatarUrl = this.getAvatarUrl(emailAddress, request, avatarUrl);
        }
        return avatarUrl;
    }

    private String encodeUrl(String url) {
        try {
            return UriUtils.encodeQueryParam((String)url, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Failed to encode URL using UTF-8; embedding URL as-is", (Throwable)e);
            return url;
        }
    }

    private String getAvatarUrl(String emailAddress, AvatarRequest request, String fallbackAvatarUrl) {
        Preconditions.checkNotNull((Object)request);
        String hash = this.hash(emailAddress);
        String defaultUrl = this.encodeUrl(fallbackAvatarUrl);
        String format = request.isSecure() ? HTTPS_GRAVATAR_URL_FORMAT : HTTP_GRAVATAR_URL_FORMAT;
        return String.format(format, hash, request.getSize(), defaultUrl);
    }

    private String hash(String emailAddress) {
        return this.md5.encodePassword(emailAddress.toLowerCase(Locale.US), null);
    }
}

