/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class TicketBucket {
    private final long defaultAcquireTimeoutMillis;
    private volatile long lastRejectedTimestamp = 0L;
    private final int permits;
    private final Semaphore semaphore;

    public TicketBucket(int permits, long defaultAcquireTimeout, @Nonnull TimeUnit unit) {
        this.defaultAcquireTimeoutMillis = Math.max(0L, unit.toMillis(defaultAcquireTimeout));
        this.permits = permits;
        this.semaphore = new Semaphore(permits, defaultAcquireTimeout > 0L);
    }

    public long getLastRejectedTimestamp() {
        return this.lastRejectedTimestamp;
    }

    public int getNumberOfPermits() {
        return this.permits;
    }

    public boolean tryAcquireTicket() {
        return this.tryAcquireTicket(this.defaultAcquireTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public boolean tryAcquireTicket(long timeout, TimeUnit timeUnit) {
        boolean acquired = false;
        try {
            acquired = this.semaphore.tryAcquire(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!acquired) {
            this.lastRejectedTimestamp = System.currentTimeMillis();
        }
        return acquired;
    }

    public void release() {
        this.semaphore.release();
    }
}

