/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.TicketAcquiredEvent;
import com.atlassian.stash.event.TicketRejectedEvent;
import com.atlassian.stash.event.TicketReleasedEvent;
import com.atlassian.stash.event.web.RequestEndedEvent;
import com.atlassian.stash.exception.NoSuchResourceException;
import com.atlassian.stash.exception.ResourceBusyException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.throttle.AbstractTicket;
import com.atlassian.stash.internal.throttle.InternalThrottleService;
import com.atlassian.stash.internal.throttle.TicketBucket;
import com.atlassian.stash.throttle.ThrottleService;
import com.atlassian.stash.throttle.Ticket;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.util.LocatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ThrottleService.class)
@Service(value="throttleService")
public class SemaphoreThrottleService
implements InternalThrottleService,
StatefulService {
    public static final String RESOURCE_PREFIX = "throttle.resource.";
    private static final Pattern BUCKET_LIMIT_PATTERN = Pattern.compile("[\\d\\+\\-\\*/\\(\\)\\s\\.]+");
    private static final Logger LOG = LoggerFactory.getLogger(SemaphoreThrottleService.class);
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final Properties properties;
    private final Map<String, TicketBucket> buckets;
    private final ThreadLocal<Ticket> tickets;
    private long resourceBusyMessageTimeout;

    @Autowired
    public SemaphoreThrottleService(EventPublisher eventPublisher, I18nService i18nService, @Qualifier(value="applicationProperties") Properties properties) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.properties = properties;
        this.buckets = new HashMap<String, TicketBucket>();
        this.tickets = new ThreadLocal();
    }

    @Nonnull
    public Ticket acquireTicket(@Nonnull String resourceName) {
        Ticket ticket = this.tickets.get();
        if (ticket == null) {
            TicketBucket bucket = this.getBucket(resourceName);
            if (bucket.tryAcquireTicket()) {
                LOG.trace("Acquired ticket for resource [{}]", (Object)resourceName);
                ticket = new SemaphoreTicket(resourceName);
                this.eventPublisher.publish((Object)new TicketAcquiredEvent((Object)this, resourceName));
                this.tickets.set(ticket);
            } else {
                this.eventPublisher.publish((Object)new TicketRejectedEvent((Object)this, resourceName));
                KeyedMessage message = this.i18nService.getKeyedText("stash.resource.busy", "The requested resource is busy and cannot service your request. Please try again later", new Object[0]);
                throw new ResourceBusyException(message, resourceName);
            }
        }
        return ticket;
    }

    public void cleanupTickets() {
        Ticket ticket = this.tickets.get();
        if (ticket != null) {
            ticket.release();
        }
    }

    public boolean hasRecentlyRejectedTicket(String resourceName) {
        return this.getBucket(resourceName).getLastRejectedTimestamp() > System.currentTimeMillis() - this.resourceBusyMessageTimeout;
    }

    @Override
    public TransferableState getState() {
        return new TicketState(this.tickets.get());
    }

    @PostConstruct
    public void initialise() {
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String propertyName = (String)names.nextElement();
            if (!propertyName.startsWith(RESOURCE_PREFIX) || propertyName.endsWith(".timeout")) continue;
            String bucketName = propertyName.substring(RESOURCE_PREFIX.length());
            int tickets = this.parseBucketLimit(bucketName, this.properties.getProperty(propertyName));
            int timeoutSeconds = Integer.parseInt(this.properties.getProperty(propertyName + ".timeout", "0"));
            LOG.debug("Configured resource [{}] with {} tickets and an acquire timeout of {} s", new Object[]{bucketName, tickets, timeoutSeconds});
            this.buckets.put(bucketName, new TicketBucket(tickets, timeoutSeconds, TimeUnit.SECONDS));
        }
    }

    @EventListener
    public void onRequestEnded(RequestEndedEvent event) {
        this.cleanupTickets();
    }

    @Value(value="${throttle.resource.busy.message.timeout}")
    public void setResourceBusyMessageTimeout(long resourceBusyMessageTimeout) {
        this.resourceBusyMessageTimeout = TimeUnit.MINUTES.toMillis(resourceBusyMessageTimeout);
    }

    int getNumberOfPermits(String resourceName) {
        return this.getBucket(resourceName).getNumberOfPermits();
    }

    private TicketBucket getBucket(String resourceName) {
        TicketBucket ticketBucket = this.buckets.get(resourceName);
        if (ticketBucket == null) {
            throw this.noSuchResource(resourceName, true);
        }
        return ticketBucket;
    }

    private NoSuchResourceException noSuchResource(String resourceName, boolean logThrowing) {
        KeyedMessage message = this.i18nService.getKeyedText("stash.resource.not.configured", "Resource [{}] is not configured", new Object[]{resourceName});
        if (logThrowing) {
            LOG.error(message.getRootMessage());
        }
        return new NoSuchResourceException(message, resourceName);
    }

    private int parseBucketLimit(String resourceName, String expression) {
        String expr = expression.toLowerCase().replace("cpu", Integer.toString(Runtime.getRuntime().availableProcessors()));
        int result = -1;
        if (BUCKET_LIMIT_PATTERN.matcher(expr).matches()) {
            try {
                ExpressionEvaluator evaluator = new ExpressionEvaluator(expr, Double.TYPE, new String[0], new Class[0]);
                result = (int)Math.round((Double)evaluator.evaluate(new Object[0]));
            }
            catch (LocatedException e) {
                LOG.debug("Error while parsing expression " + expression, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.debug("Error while evaluating expression " + expression, (Throwable)e);
            }
        }
        if (result == -1) {
            result = (int)Math.round((double)Runtime.getRuntime().availableProcessors() * 1.5);
            LOG.warn("The configured resource limit for " + resourceName + " '" + expr + "' is invalid. Only (floating point) numbers, +, -, /, *, (, ) and cpu are supported. Falling back to defaultValue: " + result);
        }
        return result;
    }

    private final class TicketState
    implements TransferableState {
        private final Ticket state;

        public TicketState(Ticket state) {
            if (state != null) {
                state = new StubTicket(state.getResourceName());
            }
            this.state = state;
        }

        @Override
        public void apply() {
            SemaphoreThrottleService.this.tickets.set(this.state);
        }

        @Override
        public void remove() {
            SemaphoreThrottleService.this.cleanupTickets();
        }
    }

    private class StubTicket
    extends AbstractTicket {
        private StubTicket(String resourceName) {
            super(resourceName);
        }

        public void release() {
            Ticket removed = (Ticket)SemaphoreThrottleService.this.tickets.get();
            if (removed != this) {
                throw new IllegalStateException("Attempted to release a ticket for resource [" + this.resourceName + "] on a thread which did not own it");
            }
            SemaphoreThrottleService.this.tickets.remove();
        }
    }

    private final class SemaphoreTicket
    extends StubTicket {
        private SemaphoreTicket(String resourceName) {
            super(resourceName);
        }

        @Override
        public void release() {
            super.release();
            LOG.trace("Released ticket for resource [{}]", (Object)this.resourceName);
            SemaphoreThrottleService.this.eventPublisher.publish((Object)new TicketReleasedEvent((Object)SemaphoreThrottleService.this, this.resourceName));
            ((TicketBucket)SemaphoreThrottleService.this.buckets.get(this.resourceName)).release();
        }
    }
}

