/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.RepositoryModifiedEvent;
import com.atlassian.stash.exception.IllegalStateException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Throttled;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.repository.RepositoryStateManager;
import com.atlassian.stash.internal.user.InternalConverter;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.repository.ScmType;
import com.atlassian.stash.scm.ScmClient;
import com.atlassian.stash.scm.ScmClientProvider;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=RepositoryService.class)
@Service(value="repositoryService")
@Transactional
public class RepositoryServiceImpl
implements RepositoryService {
    private final ScmClientProvider clientProvider;
    private final EventPublisher eventPublisher;
    private final ScheduledExecutorService executor;
    private final I18nService i18nService;
    private final int maxRepositoriesPerPage;
    private final PermissionPredicateFactory permissionPredicateFactory;
    private final ApplicationPropertiesService propertiesService;
    private final RepositoryDao repositoryDao;
    private final RepositoryStateManager repositoryStateManager;
    private final Validator validator;
    protected static final Logger LOG = LoggerFactory.getLogger(RepositoryServiceImpl.class);

    @Autowired
    public RepositoryServiceImpl(ScmClientProvider clientProvider, RepositoryDao repositoryDao, EventPublisher eventPublisher, ScheduledExecutorService executor, I18nService i18nService, Validator validator, PermissionPredicateFactory permissionPredicateFactory, RepositoryStateManager repositoryStateManager, ApplicationPropertiesService propertiesService, @Value(value="${page.max.repositories}") int maxRepositoriesPerPage) {
        this.clientProvider = clientProvider;
        this.eventPublisher = eventPublisher;
        this.executor = executor;
        this.i18nService = i18nService;
        this.maxRepositoriesPerPage = maxRepositoriesPerPage;
        this.permissionPredicateFactory = permissionPredicateFactory;
        this.propertiesService = propertiesService;
        this.repositoryDao = repositoryDao;
        this.repositoryStateManager = repositoryStateManager;
        this.validator = validator;
    }

    private void validateRepository(Repository repository, Class<?> ... groups) throws ConstraintViolationException {
        HashSet validationErrors = new HashSet();
        validationErrors.addAll(this.validator.validate((Object)repository, (Class[])groups));
        if (!validationErrors.isEmpty()) {
            throw new ConstraintViolationException(validationErrors);
        }
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    @Throttled(value="scm-command")
    public Repository createRepository(@Nonnull Project project, @Nonnull String name, @Nonnull ScmType type) {
        Preconditions.checkNotNull((Object)project, (Object)"The Project must be provided to create a repository");
        Preconditions.checkNotNull((Object)name, (Object)"The repository name cannot be null");
        Preconditions.checkNotNull((Object)type, (Object)"The repository type cannot be null");
        Repository repository = this.createRepositoryInDB(project, name, type, null);
        this.createPhysicalRepository(repository);
        return repository;
    }

    private void validateCanCreateRepositoryOnDisk(Repository repository) {
        File repositoryRoot = this.propertiesService.getRepositoryDirectory(repository);
        if (repositoryRoot.isFile()) {
            throw new IllegalStateException(this.i18nService.getKeyedText("stash.service.repository.createfailed.filepresent", "Can not create repository {0} at {1}: a file exists at the same location", new Object[]{repository.getName(), repositoryRoot}));
        }
        if (repositoryRoot.isDirectory()) {
            throw new IllegalStateException(this.i18nService.getKeyedText("stash.service.repository.createfailed.directorypresent", "Can not create repository {0} at {1}: a directory exists at the same location", new Object[]{repository.getName(), repositoryRoot}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPhysicalRepository(Repository repository) {
        Repository.State state = Repository.State.INITIALISATION_FAILED;
        try {
            this.validateCanCreateRepositoryOnDisk(repository);
            ScmClient client = this.clientProvider.get(repository);
            client.getCreateCommand(repository).call();
            state = Repository.State.AVAILABLE;
        }
        finally {
            this.repositoryStateManager.setRepositoryState(repository, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPhysicalFork(Repository parent, Repository repository) {
        Repository.State state = Repository.State.INITIALISATION_FAILED;
        try {
            this.validateCanCreateRepositoryOnDisk(repository);
            ScmClient client = this.clientProvider.get(repository);
            client.getForkCommand(parent, repository).call();
            state = Repository.State.AVAILABLE;
        }
        finally {
            this.repositoryStateManager.setRepositoryState(repository, state);
        }
    }

    @PreAuthorize(value="hasProjectPermission(#originRepository.project, 'PROJECT_ADMIN')")
    @Throttled(value="scm-command")
    public Repository forkRepository(final @Nonnull Repository originRepository, @Nonnull String name) {
        final Repository repository = this.createRepositoryInDB(originRepository.getProject(), name, originRepository.getScmType(), originRepository);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                RepositoryServiceImpl.this.createPhysicalFork(originRepository, repository);
            }
        });
        return repository;
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    @Throttled(value="scm-command")
    public Repository retryCreateRepository(@Nonnull Repository repository) {
        String name = repository.getName();
        String projectName = repository.getProject().getName();
        String projectKey = repository.getProject().getKey();
        InternalRepository existing = this.repositoryDao.findByNameAndProjectKey(name, projectKey);
        if (existing == null) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.repository.nosuchreponame", "There is no repository with name {0} in project {1}", new Object[]{name, projectName});
            throw new NoSuchEntityException(message);
        }
        if (existing.getState() == Repository.State.AVAILABLE || existing.getState() == Repository.State.INITIALISING) {
            return existing;
        }
        if (existing.getState() != Repository.State.INITIALISATION_FAILED) {
            throw new IllegalStateException(this.i18nService.getKeyedText("stash.service.repository.notuninitialised", "You can not recreate repository {0} in project {1} as it is in state {2}", new Object[]{name, projectName, existing.getState().name()}));
        }
        this.repositoryStateManager.deleteRepository((Repository)existing);
        Repository newRepository = this.createRepositoryInDB(existing.getProject(), name, existing.getScmType(), existing.getOrigin());
        if (newRepository.getOrigin() == null) {
            this.createPhysicalRepository(newRepository);
        } else {
            this.createPhysicalFork(newRepository.getOrigin(), newRepository);
        }
        return newRepository;
    }

    private Repository createRepositoryInDB(Project project, String name, ScmType type, Repository parent) {
        InternalProject internalProject = InternalConverter.convertToInternalProject(project);
        InternalRepository repository = new InternalRepository.Builder().project(internalProject).origin(InternalConverter.convertToInternalRepository(parent)).name(name).scmType(type).build();
        this.clientProvider.get((Repository)repository);
        this.validateRepository((Repository)repository, new Class[0]);
        repository = (InternalRepository)this.repositoryDao.create((Object)repository);
        repository.getProject();
        return repository;
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void deleteRepository(final @Nonnull Repository repository) {
        final File repositoryDirectory = this.propertiesService.getRepositoryDirectory(repository);
        final Iterable<Integer> childRepositories = this.repositoryStateManager.reparentChildRepositories(repository);
        this.repositoryStateManager.deleteRepository(repository);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                RepositoryServiceImpl.this.reparentChildRepositories(repository, childRepositories);
            }
        });
        this.executor.submit(new Callable<Void>(){
            int attempts = 0;

            @Override
            public Void call() throws Exception {
                try {
                    FileUtils.deleteDirectory((File)repositoryDirectory);
                }
                catch (IOException e) {
                    if (++this.attempts > 5) {
                        LOG.warn("Failed to deleted repository " + repository.getName() + " on disk after " + this.attempts + " attempts", (Throwable)e);
                    }
                    LOG.debug("Failed to delete repository " + repository.getName() + " on disk, retrying in 1 minute.");
                    RepositoryServiceImpl.this.executor.schedule(this, 1L, TimeUnit.MINUTES);
                }
                return null;
            }
        });
    }

    private void reparentChildRepositories(Repository repository, Iterable<Integer> childRepositoryIds) {
        ScmClient client = this.clientProvider.get(repository);
        File newParentRoot = null;
        if (repository.getOrigin() != null) {
            newParentRoot = this.propertiesService.getRepositoryDirectory(repository.getOrigin());
        }
        for (Integer childRepositoryId : childRepositoryIds) {
            client.getReparentCommand(this.findRepositoryById(childRepositoryId), newParentRoot).call();
        }
    }

    @Transactional(readOnly=true)
    @Secured(value="Secured using a repository predicate for Permission.REPO_READ")
    public Page<? extends Repository> findRepositoriesByProjectKey(String projectKey, PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        Predicate predicate = this.permissionPredicateFactory.createRepositoryPermissionPredicate(Permission.REPO_READ);
        return this.repositoryDao.findByProjectKey(projectKey, pageRequest, predicate);
    }

    @PostAuthorize(value="hasRepositoryPermission(returnObject, 'REPO_READ')")
    @Transactional(readOnly=true)
    public Repository findRepositoryBySlug(String projectKey, String slug) {
        return this.repositoryDao.findBySlugAndProjectKey(slug, projectKey);
    }

    @PostAuthorize(value="hasRepositoryPermission(returnObject, 'REPO_READ')")
    @Transactional(readOnly=true)
    public Repository findRepositoryById(Integer id) {
        return (Repository)this.repositoryDao.getById((Object)id);
    }

    @Transactional(readOnly=true)
    @Secured(value="Secured using a repository predicate for Permission.REPO_READ")
    public Page<? extends Repository> findAllRepositories(PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        Predicate predicate = this.permissionPredicateFactory.createRepositoryPermissionPredicate(Permission.REPO_READ);
        return this.repositoryDao.findAll(pageRequest, predicate);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public long getRepositorySize(@Nonnull Repository repository) {
        File directory = this.propertiesService.getRepositoryDirectory((Repository)Preconditions.checkNotNull((Object)repository));
        return directory.isDirectory() ? FileUtils.sizeOfDirectory((File)directory) : 0L;
    }

    @PreAuthorize(value="hasRepositoryPermission(#id, 'REPO_ADMIN')")
    public Repository updateRepository(int id, String name) {
        InternalRepository repository = (InternalRepository)this.repositoryDao.getById((Object)id);
        if (repository == null) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.repository.nosuchrepo", "There is no repository with id {0}", new Object[]{id});
            throw new NoSuchEntityException(message);
        }
        InternalRepository updatedRepository = repository.copy().name(name).build();
        this.validateRepository((Repository)updatedRepository, new Class[0]);
        updatedRepository = (InternalRepository)this.repositoryDao.update((Object)updatedRepository);
        this.eventPublisher.publish((Object)new RepositoryModifiedEvent((Object)this, (Repository)repository, (Repository)updatedRepository));
        return updatedRepository;
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_READ')")
    @Transactional(readOnly=true)
    public int countRepositoriesByProject(Project project) {
        return this.repositoryDao.countByProject(project.getId().intValue());
    }
}

