/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.internal.plugin.FormFragmentModuleDescriptor;
import com.atlassian.stash.ui.FormFragment;
import com.atlassian.stash.ui.PluginFormFragments;
import com.atlassian.stash.ui.PluginFormFragmentsFactory;
import com.atlassian.stash.ui.ValidationErrors;
import com.atlassian.stash.view.ViewStreamIOException;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pluginFormFragmentsFactory")
@AvailableToPlugins
public class PluginFormFragmentsFactoryImpl
implements PluginFormFragmentsFactory {
    public static final Function<FormFragmentModuleDescriptor, FormFragment> TO_MODULE = new Function<FormFragmentModuleDescriptor, FormFragment>(){

        public FormFragment apply(FormFragmentModuleDescriptor descriptor) {
            return descriptor.getModule();
        }
    };
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginFormFragmentsFactoryImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public PluginFormFragments forKey(final @Nonnull String formKey) {
        Preconditions.checkNotNull((Object)formKey, (Object)"formKey");
        Iterable applicableDescriptors = Iterables.filter((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(FormFragmentModuleDescriptor.class), (Predicate)new Predicate<FormFragmentModuleDescriptor>(){

            public boolean apply(FormFragmentModuleDescriptor input) {
                if (!formKey.equals(input.getLocation())) {
                    return false;
                }
                Condition condition = input.getCondition();
                return condition == null || condition.shouldDisplay(Collections.emptyMap());
            }
        });
        return new PluginFormFragmentsImpl(Lists.newArrayList((Iterable)Iterables.transform((Iterable)applicableDescriptors, TO_MODULE)));
    }

    private static class PluginFormFragmentsImpl
    implements PluginFormFragments {
        private final Iterable<FormFragment> formHandlers;

        private PluginFormFragmentsImpl(Iterable<FormFragment> formHandlers) {
            this.formHandlers = formHandlers;
        }

        public String getViewHtml() {
            StringBuilder fieldsHtml = new StringBuilder();
            for (FormFragment fragment : this.formHandlers) {
                try {
                    fragment.doView((Appendable)fieldsHtml);
                }
                catch (IOException e) {
                    throw new ViewStreamIOException("Failed to render FormFragment doView: " + fragment, (Throwable)e);
                }
            }
            return fieldsHtml.toString();
        }

        public void validate(Map<String, String[]> requestParams, ValidationErrors errors) {
            for (FormFragment fragment : this.formHandlers) {
                fragment.validate(requestParams, errors);
            }
        }

        public String getErrorHtml(Map<String, String[]> requestParams, Map<String, Collection<String>> fieldErrors) {
            StringBuilder fieldsHtml = new StringBuilder();
            for (FormFragment fragment : this.formHandlers) {
                try {
                    fragment.doError((Appendable)fieldsHtml, requestParams, fieldErrors);
                }
                catch (IOException e) {
                    throw new ViewStreamIOException("Failed to render FormFragment doError: " + fragment, (Throwable)e);
                }
            }
            return fieldsHtml.toString();
        }

        public void execute(Map<String, String[]> requestParams) {
            for (FormFragment fragment : this.formHandlers) {
                fragment.execute(requestParams);
            }
        }
    }
}

